/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.models.RulesEngineInner;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.RulesEngine;
import com.azure.resourcemanager.frontdoor.models.RulesEngineRule;
import java.util.Collections;
import java.util.List;

public final class RulesEngineImpl
implements RulesEngine,
RulesEngine.Definition,
RulesEngine.Update {
    private RulesEngineInner innerObject;
    private final FrontDoorManager serviceManager;
    private String resourceGroupName;
    private String frontDoorName;
    private String rulesEngineName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public FrontDoorResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    @Override
    public List<RulesEngineRule> rules() {
        List<RulesEngineRule> inner = this.innerModel().rules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public RulesEngineInner innerModel() {
        return this.innerObject;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }

    @Override
    public RulesEngineImpl withExistingFrontDoor(String resourceGroupName, String frontDoorName) {
        this.resourceGroupName = resourceGroupName;
        this.frontDoorName = frontDoorName;
        return this;
    }

    @Override
    public RulesEngine create() {
        this.innerObject = this.serviceManager.serviceClient().getRulesEngines().createOrUpdate(this.resourceGroupName, this.frontDoorName, this.rulesEngineName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public RulesEngine create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getRulesEngines().createOrUpdate(this.resourceGroupName, this.frontDoorName, this.rulesEngineName, this.innerModel(), context);
        return this;
    }

    RulesEngineImpl(String name, FrontDoorManager serviceManager) {
        this.innerObject = new RulesEngineInner();
        this.serviceManager = serviceManager;
        this.rulesEngineName = name;
    }

    @Override
    public RulesEngineImpl update() {
        return this;
    }

    @Override
    public RulesEngine apply() {
        this.innerObject = this.serviceManager.serviceClient().getRulesEngines().createOrUpdate(this.resourceGroupName, this.frontDoorName, this.rulesEngineName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public RulesEngine apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getRulesEngines().createOrUpdate(this.resourceGroupName, this.frontDoorName, this.rulesEngineName, this.innerModel(), context);
        return this;
    }

    RulesEngineImpl(RulesEngineInner innerObject, FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.frontDoorName = Utils.getValueFromIdByName(innerObject.id(), "frontDoors");
        this.rulesEngineName = Utils.getValueFromIdByName(innerObject.id(), "rulesEngines");
    }

    @Override
    public RulesEngine refresh() {
        this.innerObject = (RulesEngineInner)((Object)this.serviceManager.serviceClient().getRulesEngines().getWithResponse(this.resourceGroupName, this.frontDoorName, this.rulesEngineName, Context.NONE).getValue());
        return this;
    }

    @Override
    public RulesEngine refresh(Context context) {
        this.innerObject = (RulesEngineInner)((Object)this.serviceManager.serviceClient().getRulesEngines().getWithResponse(this.resourceGroupName, this.frontDoorName, this.rulesEngineName, context).getValue());
        return this;
    }

    @Override
    public RulesEngineImpl withRules(List<RulesEngineRule> rules) {
        this.innerModel().withRules(rules);
        return this;
    }
}

