/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.frontdoor.fluent.RulesEnginesClient;
import com.azure.resourcemanager.frontdoor.fluent.models.RulesEngineInner;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorManagementClientImpl;
import com.azure.resourcemanager.frontdoor.models.RulesEngineListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RulesEnginesClientImpl
implements RulesEnginesClient {
    private final RulesEnginesService service;
    private final FrontDoorManagementClientImpl client;

    RulesEnginesClientImpl(FrontDoorManagementClientImpl client) {
        this.service = (RulesEnginesService)RestProxy.create(RulesEnginesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RulesEngineInner>> listByFrontDoorSinglePageAsync(String resourceGroupName, String frontDoorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFrontDoor(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, "2021-06-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RulesEngineListResult)res.getValue()).value(), ((RulesEngineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RulesEngineInner>> listByFrontDoorSinglePageAsync(String resourceGroupName, String frontDoorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByFrontDoor(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, "2021-06-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RulesEngineListResult)res.getValue()).value(), ((RulesEngineListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RulesEngineInner> listByFrontDoorAsync(String resourceGroupName, String frontDoorName) {
        return new PagedFlux(() -> this.listByFrontDoorSinglePageAsync(resourceGroupName, frontDoorName), nextLink -> this.listByFrontDoorNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RulesEngineInner> listByFrontDoorAsync(String resourceGroupName, String frontDoorName, Context context) {
        return new PagedFlux(() -> this.listByFrontDoorSinglePageAsync(resourceGroupName, frontDoorName, context), nextLink -> this.listByFrontDoorNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RulesEngineInner> listByFrontDoor(String resourceGroupName, String frontDoorName) {
        return new PagedIterable(this.listByFrontDoorAsync(resourceGroupName, frontDoorName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RulesEngineInner> listByFrontDoor(String resourceGroupName, String frontDoorName, Context context) {
        return new PagedIterable(this.listByFrontDoorAsync(resourceGroupName, frontDoorName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RulesEngineInner>> getWithResponseAsync(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (rulesEngineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rulesEngineName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, rulesEngineName, "2021-06-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RulesEngineInner>> getWithResponseAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (rulesEngineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rulesEngineName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, rulesEngineName, "2021-06-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RulesEngineInner> getAsync(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        return this.getWithResponseAsync(resourceGroupName, frontDoorName, rulesEngineName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RulesEngineInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RulesEngineInner> getWithResponse(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, frontDoorName, rulesEngineName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RulesEngineInner get(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        return (RulesEngineInner)((Object)this.getWithResponse(resourceGroupName, frontDoorName, rulesEngineName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (rulesEngineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rulesEngineName is required and cannot be null."));
        }
        if (rulesEngineParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rulesEngineParameters is required and cannot be null."));
        }
        rulesEngineParameters.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, rulesEngineName, "2021-06-01", rulesEngineParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (rulesEngineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rulesEngineName is required and cannot be null."));
        }
        if (rulesEngineParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rulesEngineParameters is required and cannot be null."));
        }
        rulesEngineParameters.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, rulesEngineName, "2021-06-01", rulesEngineParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RulesEngineInner>, RulesEngineInner> beginCreateOrUpdateAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, frontDoorName, rulesEngineName, rulesEngineParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)RulesEngineInner.class), (Type)((Object)RulesEngineInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RulesEngineInner>, RulesEngineInner> beginCreateOrUpdateAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, frontDoorName, rulesEngineName, rulesEngineParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)RulesEngineInner.class), (Type)((Object)RulesEngineInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RulesEngineInner>, RulesEngineInner> beginCreateOrUpdate(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, frontDoorName, rulesEngineName, rulesEngineParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RulesEngineInner>, RulesEngineInner> beginCreateOrUpdate(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, frontDoorName, rulesEngineName, rulesEngineParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RulesEngineInner> createOrUpdateAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, frontDoorName, rulesEngineName, rulesEngineParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RulesEngineInner> createOrUpdateAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, frontDoorName, rulesEngineName, rulesEngineParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RulesEngineInner createOrUpdate(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters) {
        return (RulesEngineInner)((Object)this.createOrUpdateAsync(resourceGroupName, frontDoorName, rulesEngineName, rulesEngineParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RulesEngineInner createOrUpdate(String resourceGroupName, String frontDoorName, String rulesEngineName, RulesEngineInner rulesEngineParameters, Context context) {
        return (RulesEngineInner)((Object)this.createOrUpdateAsync(resourceGroupName, frontDoorName, rulesEngineName, rulesEngineParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (rulesEngineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rulesEngineName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, rulesEngineName, "2021-06-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (rulesEngineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter rulesEngineName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, rulesEngineName, "2021-06-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, frontDoorName, rulesEngineName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, frontDoorName, rulesEngineName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        return this.beginDeleteAsync(resourceGroupName, frontDoorName, rulesEngineName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, frontDoorName, rulesEngineName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        return this.beginDeleteAsync(resourceGroupName, frontDoorName, rulesEngineName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, frontDoorName, rulesEngineName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        this.deleteAsync(resourceGroupName, frontDoorName, rulesEngineName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        this.deleteAsync(resourceGroupName, frontDoorName, rulesEngineName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RulesEngineInner>> listByFrontDoorNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFrontDoorNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RulesEngineListResult)res.getValue()).value(), ((RulesEngineListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RulesEngineInner>> listByFrontDoorNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByFrontDoorNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RulesEngineListResult)res.getValue()).value(), ((RulesEngineListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FrontDoorManagementC")
    public static interface RulesEnginesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/rulesEngines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RulesEngineListResult>> listByFrontDoor(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="frontDoorName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/rulesEngines/{rulesEngineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RulesEngineInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="frontDoorName") String var4, @PathParam(value="rulesEngineName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/rulesEngines/{rulesEngineName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="frontDoorName") String var4, @PathParam(value="rulesEngineName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") RulesEngineInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/rulesEngines/{rulesEngineName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="frontDoorName") String var4, @PathParam(value="rulesEngineName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RulesEngineListResult>> listByFrontDoorNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

