/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.RulesEnginesClient;
import com.azure.resourcemanager.frontdoor.fluent.models.RulesEngineInner;
import com.azure.resourcemanager.frontdoor.implementation.RulesEngineImpl;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.RulesEngine;
import com.azure.resourcemanager.frontdoor.models.RulesEngines;

public final class RulesEnginesImpl
implements RulesEngines {
    private static final ClientLogger LOGGER = new ClientLogger(RulesEnginesImpl.class);
    private final RulesEnginesClient innerClient;
    private final FrontDoorManager serviceManager;

    public RulesEnginesImpl(RulesEnginesClient innerClient, FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<RulesEngine> listByFrontDoor(String resourceGroupName, String frontDoorName) {
        PagedIterable<RulesEngineInner> inner = this.serviceClient().listByFrontDoor(resourceGroupName, frontDoorName);
        return Utils.mapPage(inner, inner1 -> new RulesEngineImpl((RulesEngineInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<RulesEngine> listByFrontDoor(String resourceGroupName, String frontDoorName, Context context) {
        PagedIterable<RulesEngineInner> inner = this.serviceClient().listByFrontDoor(resourceGroupName, frontDoorName, context);
        return Utils.mapPage(inner, inner1 -> new RulesEngineImpl((RulesEngineInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<RulesEngine> getWithResponse(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        Response<RulesEngineInner> inner = this.serviceClient().getWithResponse(resourceGroupName, frontDoorName, rulesEngineName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RulesEngineImpl((RulesEngineInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RulesEngine get(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        RulesEngineInner inner = this.serviceClient().get(resourceGroupName, frontDoorName, rulesEngineName);
        if (inner != null) {
            return new RulesEngineImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        this.serviceClient().delete(resourceGroupName, frontDoorName, rulesEngineName);
    }

    @Override
    public void delete(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        this.serviceClient().delete(resourceGroupName, frontDoorName, rulesEngineName, context);
    }

    @Override
    public RulesEngine getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        String rulesEngineName = Utils.getValueFromIdByName(id, "rulesEngines");
        if (rulesEngineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'rulesEngines'.", id)));
        }
        return (RulesEngine)this.getWithResponse(resourceGroupName, frontDoorName, rulesEngineName, Context.NONE).getValue();
    }

    @Override
    public Response<RulesEngine> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        String rulesEngineName = Utils.getValueFromIdByName(id, "rulesEngines");
        if (rulesEngineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'rulesEngines'.", id)));
        }
        return this.getWithResponse(resourceGroupName, frontDoorName, rulesEngineName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        String rulesEngineName = Utils.getValueFromIdByName(id, "rulesEngines");
        if (rulesEngineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'rulesEngines'.", id)));
        }
        this.delete(resourceGroupName, frontDoorName, rulesEngineName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        String rulesEngineName = Utils.getValueFromIdByName(id, "rulesEngines");
        if (rulesEngineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'rulesEngines'.", id)));
        }
        this.delete(resourceGroupName, frontDoorName, rulesEngineName, context);
    }

    private RulesEnginesClient serviceClient() {
        return this.innerClient;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }

    @Override
    public RulesEngineImpl define(String name) {
        return new RulesEngineImpl(name, this.manager());
    }
}

