/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.models.WebApplicationFirewallPolicyInner;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.CustomRuleList;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointLink;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleSetList;
import com.azure.resourcemanager.frontdoor.models.PolicyResourceState;
import com.azure.resourcemanager.frontdoor.models.PolicySettings;
import com.azure.resourcemanager.frontdoor.models.RoutingRuleLink;
import com.azure.resourcemanager.frontdoor.models.SecurityPolicyLink;
import com.azure.resourcemanager.frontdoor.models.Sku;
import com.azure.resourcemanager.frontdoor.models.TagsObject;
import com.azure.resourcemanager.frontdoor.models.WebApplicationFirewallPolicy;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class WebApplicationFirewallPolicyImpl
implements WebApplicationFirewallPolicy,
WebApplicationFirewallPolicy.Definition,
WebApplicationFirewallPolicy.Update {
    private WebApplicationFirewallPolicyInner innerObject;
    private final FrontDoorManager serviceManager;
    private String resourceGroupName;
    private String policyName;
    private TagsObject updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public PolicySettings policySettings() {
        return this.innerModel().policySettings();
    }

    @Override
    public CustomRuleList customRules() {
        return this.innerModel().customRules();
    }

    @Override
    public ManagedRuleSetList managedRules() {
        return this.innerModel().managedRules();
    }

    @Override
    public List<FrontendEndpointLink> frontendEndpointLinks() {
        List<FrontendEndpointLink> inner = this.innerModel().frontendEndpointLinks();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<RoutingRuleLink> routingRuleLinks() {
        List<RoutingRuleLink> inner = this.innerModel().routingRuleLinks();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<SecurityPolicyLink> securityPolicyLinks() {
        List<SecurityPolicyLink> inner = this.innerModel().securityPolicyLinks();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public PolicyResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WebApplicationFirewallPolicyInner innerModel() {
        return this.innerObject;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public WebApplicationFirewallPolicy create() {
        this.innerObject = this.serviceManager.serviceClient().getPolicies().createOrUpdate(this.resourceGroupName, this.policyName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicy create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPolicies().createOrUpdate(this.resourceGroupName, this.policyName, this.innerModel(), context);
        return this;
    }

    WebApplicationFirewallPolicyImpl(String name, FrontDoorManager serviceManager) {
        this.innerObject = new WebApplicationFirewallPolicyInner();
        this.serviceManager = serviceManager;
        this.policyName = name;
    }

    @Override
    public WebApplicationFirewallPolicyImpl update() {
        this.updateParameters = new TagsObject();
        return this;
    }

    @Override
    public WebApplicationFirewallPolicy apply() {
        this.innerObject = this.serviceManager.serviceClient().getPolicies().update(this.resourceGroupName, this.policyName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicy apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPolicies().update(this.resourceGroupName, this.policyName, this.updateParameters, context);
        return this;
    }

    WebApplicationFirewallPolicyImpl(WebApplicationFirewallPolicyInner innerObject, FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.policyName = Utils.getValueFromIdByName(innerObject.id(), "FrontDoorWebApplicationFirewallPolicies");
    }

    @Override
    public WebApplicationFirewallPolicy refresh() {
        this.innerObject = (WebApplicationFirewallPolicyInner)((Object)this.serviceManager.serviceClient().getPolicies().getByResourceGroupWithResponse(this.resourceGroupName, this.policyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public WebApplicationFirewallPolicy refresh(Context context) {
        this.innerObject = (WebApplicationFirewallPolicyInner)((Object)this.serviceManager.serviceClient().getPolicies().getByResourceGroupWithResponse(this.resourceGroupName, this.policyName, context).getValue());
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withSku(Sku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withPolicySettings(PolicySettings policySettings) {
        this.innerModel().withPolicySettings(policySettings);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withCustomRules(CustomRuleList customRules) {
        this.innerModel().withCustomRules(customRules);
        return this;
    }

    @Override
    public WebApplicationFirewallPolicyImpl withManagedRules(ManagedRuleSetList managedRules) {
        this.innerModel().withManagedRules(managedRules);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

