/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.frontdoor.fluent.models.BackendPoolProperties;
import com.azure.resourcemanager.frontdoor.models.Backend;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BackendPool
extends SubResource {
    @JsonProperty(value="properties")
    private BackendPoolProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private BackendPoolProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public BackendPool withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public BackendPool withId(String id) {
        super.withId(id);
        return this;
    }

    public FrontDoorResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public List<Backend> backends() {
        return this.innerProperties() == null ? null : this.innerProperties().backends();
    }

    public BackendPool withBackends(List<Backend> backends) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendPoolProperties();
        }
        this.innerProperties().withBackends((List)backends);
        return this;
    }

    public SubResource loadBalancingSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancingSettings();
    }

    public BackendPool withLoadBalancingSettings(SubResource loadBalancingSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendPoolProperties();
        }
        this.innerProperties().withLoadBalancingSettings(loadBalancingSettings);
        return this;
    }

    public SubResource healthProbeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().healthProbeSettings();
    }

    public BackendPool withHealthProbeSettings(SubResource healthProbeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendPoolProperties();
        }
        this.innerProperties().withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

