/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontDoorCertificateSourceParameters;
import com.azure.resourcemanager.frontdoor.fluent.models.KeyVaultCertificateSourceParameters;
import com.azure.resourcemanager.frontdoor.models.FrontDoorCertificateSource;
import com.azure.resourcemanager.frontdoor.models.FrontDoorCertificateType;
import com.azure.resourcemanager.frontdoor.models.FrontDoorTlsProtocolType;
import com.azure.resourcemanager.frontdoor.models.KeyVaultCertificateSourceParametersVault;
import com.azure.resourcemanager.frontdoor.models.MinimumTlsVersion;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class CustomHttpsConfiguration {
    @JsonProperty(value="certificateSource", required=true)
    private FrontDoorCertificateSource certificateSource;
    @JsonProperty(value="protocolType", required=true)
    private FrontDoorTlsProtocolType protocolType;
    @JsonProperty(value="minimumTlsVersion", required=true)
    private MinimumTlsVersion minimumTlsVersion;
    @JsonProperty(value="keyVaultCertificateSourceParameters")
    private KeyVaultCertificateSourceParameters innerKeyVaultCertificateSourceParameters;
    @JsonProperty(value="frontDoorCertificateSourceParameters")
    private FrontDoorCertificateSourceParameters innerFrontDoorCertificateSourceParameters;
    private static final ClientLogger LOGGER = new ClientLogger(CustomHttpsConfiguration.class);

    public FrontDoorCertificateSource certificateSource() {
        return this.certificateSource;
    }

    public CustomHttpsConfiguration withCertificateSource(FrontDoorCertificateSource certificateSource) {
        this.certificateSource = certificateSource;
        return this;
    }

    public FrontDoorTlsProtocolType protocolType() {
        return this.protocolType;
    }

    public CustomHttpsConfiguration withProtocolType(FrontDoorTlsProtocolType protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public CustomHttpsConfiguration withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    private KeyVaultCertificateSourceParameters innerKeyVaultCertificateSourceParameters() {
        return this.innerKeyVaultCertificateSourceParameters;
    }

    private FrontDoorCertificateSourceParameters innerFrontDoorCertificateSourceParameters() {
        return this.innerFrontDoorCertificateSourceParameters;
    }

    public KeyVaultCertificateSourceParametersVault vault() {
        return this.innerKeyVaultCertificateSourceParameters() == null ? null : this.innerKeyVaultCertificateSourceParameters().vault();
    }

    public CustomHttpsConfiguration withVault(KeyVaultCertificateSourceParametersVault vault) {
        if (this.innerKeyVaultCertificateSourceParameters() == null) {
            this.innerKeyVaultCertificateSourceParameters = new KeyVaultCertificateSourceParameters();
        }
        this.innerKeyVaultCertificateSourceParameters().withVault(vault);
        return this;
    }

    public String secretName() {
        return this.innerKeyVaultCertificateSourceParameters() == null ? null : this.innerKeyVaultCertificateSourceParameters().secretName();
    }

    public CustomHttpsConfiguration withSecretName(String secretName) {
        if (this.innerKeyVaultCertificateSourceParameters() == null) {
            this.innerKeyVaultCertificateSourceParameters = new KeyVaultCertificateSourceParameters();
        }
        this.innerKeyVaultCertificateSourceParameters().withSecretName(secretName);
        return this;
    }

    public String secretVersion() {
        return this.innerKeyVaultCertificateSourceParameters() == null ? null : this.innerKeyVaultCertificateSourceParameters().secretVersion();
    }

    public CustomHttpsConfiguration withSecretVersion(String secretVersion) {
        if (this.innerKeyVaultCertificateSourceParameters() == null) {
            this.innerKeyVaultCertificateSourceParameters = new KeyVaultCertificateSourceParameters();
        }
        this.innerKeyVaultCertificateSourceParameters().withSecretVersion(secretVersion);
        return this;
    }

    public FrontDoorCertificateType certificateType() {
        return this.innerFrontDoorCertificateSourceParameters() == null ? null : this.innerFrontDoorCertificateSourceParameters().certificateType();
    }

    public CustomHttpsConfiguration withCertificateType(FrontDoorCertificateType certificateType) {
        if (this.innerFrontDoorCertificateSourceParameters() == null) {
            this.innerFrontDoorCertificateSourceParameters = new FrontDoorCertificateSourceParameters();
        }
        this.innerFrontDoorCertificateSourceParameters().withCertificateType(certificateType);
        return this;
    }

    public void validate() {
        if (this.certificateSource() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property certificateSource in model CustomHttpsConfiguration"));
        }
        if (this.protocolType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property protocolType in model CustomHttpsConfiguration"));
        }
        if (this.minimumTlsVersion() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property minimumTlsVersion in model CustomHttpsConfiguration"));
        }
        if (this.innerKeyVaultCertificateSourceParameters() != null) {
            this.innerKeyVaultCertificateSourceParameters().validate();
        }
        if (this.innerFrontDoorCertificateSourceParameters() != null) {
            this.innerFrontDoorCertificateSourceParameters().validate();
        }
    }
}

