/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.models.ActionType;
import com.azure.resourcemanager.frontdoor.models.CustomRuleEnabledState;
import com.azure.resourcemanager.frontdoor.models.MatchCondition;
import com.azure.resourcemanager.frontdoor.models.RuleType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class CustomRule {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="priority", required=true)
    private int priority;
    @JsonProperty(value="enabledState")
    private CustomRuleEnabledState enabledState;
    @JsonProperty(value="ruleType", required=true)
    private RuleType ruleType;
    @JsonProperty(value="rateLimitDurationInMinutes")
    private Integer rateLimitDurationInMinutes;
    @JsonProperty(value="rateLimitThreshold")
    private Integer rateLimitThreshold;
    @JsonProperty(value="matchConditions", required=true)
    private List<MatchCondition> matchConditions;
    @JsonProperty(value="action", required=true)
    private ActionType action;
    private static final ClientLogger LOGGER = new ClientLogger(CustomRule.class);

    public String name() {
        return this.name;
    }

    public CustomRule withName(String name) {
        this.name = name;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public CustomRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public CustomRuleEnabledState enabledState() {
        return this.enabledState;
    }

    public CustomRule withEnabledState(CustomRuleEnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    public RuleType ruleType() {
        return this.ruleType;
    }

    public CustomRule withRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    public Integer rateLimitDurationInMinutes() {
        return this.rateLimitDurationInMinutes;
    }

    public CustomRule withRateLimitDurationInMinutes(Integer rateLimitDurationInMinutes) {
        this.rateLimitDurationInMinutes = rateLimitDurationInMinutes;
        return this;
    }

    public Integer rateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    public CustomRule withRateLimitThreshold(Integer rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
        return this;
    }

    public List<MatchCondition> matchConditions() {
        return this.matchConditions;
    }

    public CustomRule withMatchConditions(List<MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    public ActionType action() {
        return this.action;
    }

    public CustomRule withAction(ActionType action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.ruleType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ruleType in model CustomRule"));
        }
        if (this.matchConditions() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property matchConditions in model CustomRule"));
        }
        this.matchConditions().forEach(e -> e.validate());
        if (this.action() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property action in model CustomRule"));
        }
    }
}

