/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.fluent.models.ExperimentInner;
import com.azure.resourcemanager.frontdoor.models.Endpoint;
import com.azure.resourcemanager.frontdoor.models.NetworkExperimentResourceState;
import com.azure.resourcemanager.frontdoor.models.State;
import java.util.Map;

public interface Experiment {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String description();

    public Endpoint endpointA();

    public Endpoint endpointB();

    public State enabledState();

    public NetworkExperimentResourceState resourceState();

    public String status();

    public String scriptFileUri();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ExperimentInner innerModel();

    public Update update();

    public Experiment refresh();

    public Experiment refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithEnabledState {
            public Update withEnabledState(State var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithDescription,
    UpdateStages.WithEnabledState {
        public Experiment apply();

        public Experiment apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEnabledState {
            public WithCreate withEnabledState(State var1);
        }

        public static interface WithEndpointB {
            public WithCreate withEndpointB(Endpoint var1);
        }

        public static interface WithEndpointA {
            public WithCreate withEndpointA(Endpoint var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithDescription,
        WithEndpointA,
        WithEndpointB,
        WithEnabledState {
            public Experiment create();

            public Experiment create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingNetworkExperimentProfile(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

