/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontDoorInner;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontendEndpointInner;
import com.azure.resourcemanager.frontdoor.models.BackendPool;
import com.azure.resourcemanager.frontdoor.models.BackendPoolsSettings;
import com.azure.resourcemanager.frontdoor.models.FrontDoorEnabledState;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpoint;
import com.azure.resourcemanager.frontdoor.models.HealthProbeSettingsModel;
import com.azure.resourcemanager.frontdoor.models.LoadBalancingSettingsModel;
import com.azure.resourcemanager.frontdoor.models.RoutingRule;
import com.azure.resourcemanager.frontdoor.models.RulesEngine;
import com.azure.resourcemanager.frontdoor.models.ValidateCustomDomainInput;
import com.azure.resourcemanager.frontdoor.models.ValidateCustomDomainOutput;
import java.util.List;
import java.util.Map;

public interface FrontDoor {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public FrontDoorResourceState resourceState();

    public String provisioningState();

    public String cname();

    public String frontdoorId();

    public List<RulesEngine> rulesEngines();

    public Map<String, String> extendedProperties();

    public String friendlyName();

    public List<RoutingRule> routingRules();

    public List<LoadBalancingSettingsModel> loadBalancingSettings();

    public List<HealthProbeSettingsModel> healthProbeSettings();

    public List<BackendPool> backendPools();

    public List<FrontendEndpoint> frontendEndpoints();

    public BackendPoolsSettings backendPoolsSettings();

    public FrontDoorEnabledState enabledState();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public FrontDoorInner innerModel();

    public Update update();

    public FrontDoor refresh();

    public FrontDoor refresh(Context var1);

    public Response<ValidateCustomDomainOutput> validateCustomDomainWithResponse(ValidateCustomDomainInput var1, Context var2);

    public ValidateCustomDomainOutput validateCustomDomain(ValidateCustomDomainInput var1);

    public static interface UpdateStages {

        public static interface WithEnabledState {
            public Update withEnabledState(FrontDoorEnabledState var1);
        }

        public static interface WithBackendPoolsSettings {
            public Update withBackendPoolsSettings(BackendPoolsSettings var1);
        }

        public static interface WithFrontendEndpoints {
            public Update withFrontendEndpoints(List<FrontendEndpointInner> var1);
        }

        public static interface WithBackendPools {
            public Update withBackendPools(List<BackendPool> var1);
        }

        public static interface WithHealthProbeSettings {
            public Update withHealthProbeSettings(List<HealthProbeSettingsModel> var1);
        }

        public static interface WithLoadBalancingSettings {
            public Update withLoadBalancingSettings(List<LoadBalancingSettingsModel> var1);
        }

        public static interface WithRoutingRules {
            public Update withRoutingRules(List<RoutingRule> var1);
        }

        public static interface WithFriendlyName {
            public Update withFriendlyName(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithFriendlyName,
    UpdateStages.WithRoutingRules,
    UpdateStages.WithLoadBalancingSettings,
    UpdateStages.WithHealthProbeSettings,
    UpdateStages.WithBackendPools,
    UpdateStages.WithFrontendEndpoints,
    UpdateStages.WithBackendPoolsSettings,
    UpdateStages.WithEnabledState {
        public FrontDoor apply();

        public FrontDoor apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithEnabledState {
            public WithCreate withEnabledState(FrontDoorEnabledState var1);
        }

        public static interface WithBackendPoolsSettings {
            public WithCreate withBackendPoolsSettings(BackendPoolsSettings var1);
        }

        public static interface WithFrontendEndpoints {
            public WithCreate withFrontendEndpoints(List<FrontendEndpointInner> var1);
        }

        public static interface WithBackendPools {
            public WithCreate withBackendPools(List<BackendPool> var1);
        }

        public static interface WithHealthProbeSettings {
            public WithCreate withHealthProbeSettings(List<HealthProbeSettingsModel> var1);
        }

        public static interface WithLoadBalancingSettings {
            public WithCreate withLoadBalancingSettings(List<LoadBalancingSettingsModel> var1);
        }

        public static interface WithRoutingRules {
            public WithCreate withRoutingRules(List<RoutingRule> var1);
        }

        public static interface WithFriendlyName {
            public WithCreate withFriendlyName(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithFriendlyName,
        WithRoutingRules,
        WithLoadBalancingSettings,
        WithHealthProbeSettings,
        WithBackendPools,
        WithFrontendEndpoints,
        WithBackendPoolsSettings,
        WithEnabledState {
            public FrontDoor create();

            public FrontDoor create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

