/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.frontdoor.fluent.models.HealthProbeSettingsProperties;
import com.azure.resourcemanager.frontdoor.models.FrontDoorHealthProbeMethod;
import com.azure.resourcemanager.frontdoor.models.FrontDoorProtocol;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.HealthProbeEnabled;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class HealthProbeSettingsModel
extends SubResource {
    @JsonProperty(value="properties")
    private HealthProbeSettingsProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private HealthProbeSettingsProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public HealthProbeSettingsModel withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public HealthProbeSettingsModel withId(String id) {
        super.withId(id);
        return this;
    }

    public FrontDoorResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public String path() {
        return this.innerProperties() == null ? null : this.innerProperties().path();
    }

    public HealthProbeSettingsModel withPath(String path) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HealthProbeSettingsProperties();
        }
        this.innerProperties().withPath(path);
        return this;
    }

    public FrontDoorProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public HealthProbeSettingsModel withProtocol(FrontDoorProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HealthProbeSettingsProperties();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public Integer intervalInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().intervalInSeconds();
    }

    public HealthProbeSettingsModel withIntervalInSeconds(Integer intervalInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HealthProbeSettingsProperties();
        }
        this.innerProperties().withIntervalInSeconds(intervalInSeconds);
        return this;
    }

    public FrontDoorHealthProbeMethod healthProbeMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().healthProbeMethod();
    }

    public HealthProbeSettingsModel withHealthProbeMethod(FrontDoorHealthProbeMethod healthProbeMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HealthProbeSettingsProperties();
        }
        this.innerProperties().withHealthProbeMethod(healthProbeMethod);
        return this;
    }

    public HealthProbeEnabled enabledState() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledState();
    }

    public HealthProbeSettingsModel withEnabledState(HealthProbeEnabled enabledState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HealthProbeSettingsProperties();
        }
        this.innerProperties().withEnabledState(enabledState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

