/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleExclusion;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleGroupOverride;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleSetActionType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ManagedRuleSet {
    @JsonProperty(value="ruleSetType", required=true)
    private String ruleSetType;
    @JsonProperty(value="ruleSetVersion", required=true)
    private String ruleSetVersion;
    @JsonProperty(value="ruleSetAction")
    private ManagedRuleSetActionType ruleSetAction;
    @JsonProperty(value="exclusions")
    private List<ManagedRuleExclusion> exclusions;
    @JsonProperty(value="ruleGroupOverrides")
    private List<ManagedRuleGroupOverride> ruleGroupOverrides;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleSet.class);

    public String ruleSetType() {
        return this.ruleSetType;
    }

    public ManagedRuleSet withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    public ManagedRuleSet withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    public ManagedRuleSetActionType ruleSetAction() {
        return this.ruleSetAction;
    }

    public ManagedRuleSet withRuleSetAction(ManagedRuleSetActionType ruleSetAction) {
        this.ruleSetAction = ruleSetAction;
        return this;
    }

    public List<ManagedRuleExclusion> exclusions() {
        return this.exclusions;
    }

    public ManagedRuleSet withExclusions(List<ManagedRuleExclusion> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public List<ManagedRuleGroupOverride> ruleGroupOverrides() {
        return this.ruleGroupOverrides;
    }

    public ManagedRuleSet withRuleGroupOverrides(List<ManagedRuleGroupOverride> ruleGroupOverrides) {
        this.ruleGroupOverrides = ruleGroupOverrides;
        return this;
    }

    public void validate() {
        if (this.ruleSetType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ruleSetType in model ManagedRuleSet"));
        }
        if (this.ruleSetVersion() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ruleSetVersion in model ManagedRuleSet"));
        }
        if (this.exclusions() != null) {
            this.exclusions().forEach(e -> e.validate());
        }
        if (this.ruleGroupOverrides() != null) {
            this.ruleGroupOverrides().forEach(e -> e.validate());
        }
    }
}

