/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.models.MatchVariable;
import com.azure.resourcemanager.frontdoor.models.Operator;
import com.azure.resourcemanager.frontdoor.models.TransformType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class MatchCondition {
    @JsonProperty(value="matchVariable", required=true)
    private MatchVariable matchVariable;
    @JsonProperty(value="selector")
    private String selector;
    @JsonProperty(value="operator", required=true)
    private Operator operator;
    @JsonProperty(value="negateCondition")
    private Boolean negateCondition;
    @JsonProperty(value="matchValue", required=true)
    private List<String> matchValue;
    @JsonProperty(value="transforms")
    private List<TransformType> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(MatchCondition.class);

    public MatchVariable matchVariable() {
        return this.matchVariable;
    }

    public MatchCondition withMatchVariable(MatchVariable matchVariable) {
        this.matchVariable = matchVariable;
        return this;
    }

    public String selector() {
        return this.selector;
    }

    public MatchCondition withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    public Operator operator() {
        return this.operator;
    }

    public MatchCondition withOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public MatchCondition withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<String> matchValue() {
        return this.matchValue;
    }

    public MatchCondition withMatchValue(List<String> matchValue) {
        this.matchValue = matchValue;
        return this;
    }

    public List<TransformType> transforms() {
        return this.transforms;
    }

    public MatchCondition withTransforms(List<TransformType> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.matchVariable() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property matchVariable in model MatchCondition"));
        }
        if (this.operator() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property operator in model MatchCondition"));
        }
        if (this.matchValue() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property matchValue in model MatchCondition"));
        }
    }
}

