/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.frontdoor.fluent.models.RoutingRuleProperties;
import com.azure.resourcemanager.frontdoor.models.FrontDoorProtocol;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.RouteConfiguration;
import com.azure.resourcemanager.frontdoor.models.RoutingRuleEnabledState;
import com.azure.resourcemanager.frontdoor.models.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RoutingRule
extends SubResource {
    @JsonProperty(value="properties")
    private RoutingRuleProperties innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private RoutingRuleProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public RoutingRule withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public RoutingRule withId(String id) {
        super.withId(id);
        return this;
    }

    public FrontDoorResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public List<SubResource> frontendEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendEndpoints();
    }

    public RoutingRule withFrontendEndpoints(List<SubResource> frontendEndpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withFrontendEndpoints((List)frontendEndpoints);
        return this;
    }

    public List<FrontDoorProtocol> acceptedProtocols() {
        return this.innerProperties() == null ? null : this.innerProperties().acceptedProtocols();
    }

    public RoutingRule withAcceptedProtocols(List<FrontDoorProtocol> acceptedProtocols) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withAcceptedProtocols((List)acceptedProtocols);
        return this;
    }

    public List<String> patternsToMatch() {
        return this.innerProperties() == null ? null : this.innerProperties().patternsToMatch();
    }

    public RoutingRule withPatternsToMatch(List<String> patternsToMatch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withPatternsToMatch((List)patternsToMatch);
        return this;
    }

    public RoutingRuleEnabledState enabledState() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledState();
    }

    public RoutingRule withEnabledState(RoutingRuleEnabledState enabledState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withEnabledState(enabledState);
        return this;
    }

    public RouteConfiguration routeConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().routeConfiguration();
    }

    public RoutingRule withRouteConfiguration(RouteConfiguration routeConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withRouteConfiguration(routeConfiguration);
        return this;
    }

    public SubResource rulesEngine() {
        return this.innerProperties() == null ? null : this.innerProperties().rulesEngine();
    }

    public RoutingRule withRulesEngine(SubResource rulesEngine) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withRulesEngine(rulesEngine);
        return this;
    }

    public RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.innerProperties() == null ? null : this.innerProperties().webApplicationFirewallPolicyLink();
    }

    public RoutingRule withWebApplicationFirewallPolicyLink(RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

