/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.models.MatchProcessingBehavior;
import com.azure.resourcemanager.frontdoor.models.RulesEngineAction;
import com.azure.resourcemanager.frontdoor.models.RulesEngineMatchCondition;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RulesEngineRule {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="priority", required=true)
    private int priority;
    @JsonProperty(value="action", required=true)
    private RulesEngineAction action;
    @JsonProperty(value="matchConditions")
    private List<RulesEngineMatchCondition> matchConditions;
    @JsonProperty(value="matchProcessingBehavior")
    private MatchProcessingBehavior matchProcessingBehavior;
    private static final ClientLogger LOGGER = new ClientLogger(RulesEngineRule.class);

    public String name() {
        return this.name;
    }

    public RulesEngineRule withName(String name) {
        this.name = name;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public RulesEngineRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public RulesEngineAction action() {
        return this.action;
    }

    public RulesEngineRule withAction(RulesEngineAction action) {
        this.action = action;
        return this;
    }

    public List<RulesEngineMatchCondition> matchConditions() {
        return this.matchConditions;
    }

    public RulesEngineRule withMatchConditions(List<RulesEngineMatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    public MatchProcessingBehavior matchProcessingBehavior() {
        return this.matchProcessingBehavior;
    }

    public RulesEngineRule withMatchProcessingBehavior(MatchProcessingBehavior matchProcessingBehavior) {
        this.matchProcessingBehavior = matchProcessingBehavior;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model RulesEngineRule"));
        }
        if (this.action() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property action in model RulesEngineRule"));
        }
        this.action().validate();
        if (this.matchConditions() != null) {
            this.matchConditions().forEach(e -> e.validate());
        }
    }
}

