// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.impactreporting.fluent.models.InsightInner;

/**
 * An instance of this class provides access to all the operations defined in InsightsClient.
 */
public interface InsightsClient {
    /**
     * Get Insight resources by workloadImpactName and insightName.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return insight resources by workloadImpactName and insightName along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<InsightInner> getWithResponse(String workloadImpactName, String insightName, Context context);

    /**
     * Get Insight resources by workloadImpactName and insightName.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return insight resources by workloadImpactName and insightName.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    InsightInner get(String workloadImpactName, String insightName);

    /**
     * List Insight resources by workloadImpactName.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Insight list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<InsightInner> listBySubscription(String workloadImpactName);

    /**
     * List Insight resources by workloadImpactName.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Insight list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<InsightInner> listBySubscription(String workloadImpactName, Context context);

    /**
     * Create Insight resource, This is Admin only operation.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @param resource Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return insight resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<InsightInner> createWithResponse(String workloadImpactName, String insightName, InsightInner resource,
        Context context);

    /**
     * Create Insight resource, This is Admin only operation.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @param resource Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return insight resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    InsightInner create(String workloadImpactName, String insightName, InsightInner resource);

    /**
     * Delete Insight resource, This is Admin only operation.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String workloadImpactName, String insightName, Context context);

    /**
     * Delete Insight resource, This is Admin only operation.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String workloadImpactName, String insightName);
}
