// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.impactreporting.fluent.models.WorkloadImpactInner;

/**
 * An instance of this class provides access to all the operations defined in WorkloadImpactsClient.
 */
public interface WorkloadImpactsClient {
    /**
     * Create a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param resource Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of workload Impact properties.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WorkloadImpactInner>, WorkloadImpactInner> beginCreate(String workloadImpactName,
        WorkloadImpactInner resource);

    /**
     * Create a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param resource Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of workload Impact properties.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<WorkloadImpactInner>, WorkloadImpactInner> beginCreate(String workloadImpactName,
        WorkloadImpactInner resource, Context context);

    /**
     * Create a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param resource Resource create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return workload Impact properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WorkloadImpactInner create(String workloadImpactName, WorkloadImpactInner resource);

    /**
     * Create a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param resource Resource create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return workload Impact properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WorkloadImpactInner create(String workloadImpactName, WorkloadImpactInner resource, Context context);

    /**
     * Get a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a WorkloadImpact along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<WorkloadImpactInner> getWithResponse(String workloadImpactName, Context context);

    /**
     * Get a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a WorkloadImpact.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WorkloadImpactInner get(String workloadImpactName);

    /**
     * Delete a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String workloadImpactName, Context context);

    /**
     * Delete a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String workloadImpactName);

    /**
     * List WorkloadImpact resources by subscription ID.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a WorkloadImpact list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<WorkloadImpactInner> list();

    /**
     * List WorkloadImpact resources by subscription ID.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a WorkloadImpact list operation as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<WorkloadImpactInner> list(Context context);
}
