// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.impactreporting.fluent.models.ConnectorInner;
import com.azure.resourcemanager.impactreporting.models.Connector;
import com.azure.resourcemanager.impactreporting.models.ConnectorProperties;
import com.azure.resourcemanager.impactreporting.models.ConnectorUpdate;
import com.azure.resourcemanager.impactreporting.models.ConnectorUpdateProperties;

public final class ConnectorImpl implements Connector, Connector.Definition, Connector.Update {
    private ConnectorInner innerObject;

    private final com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public ConnectorProperties properties() {
        return this.innerModel().properties();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public ConnectorInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.impactreporting.ImpactReportingManager manager() {
        return this.serviceManager;
    }

    private String connectorName;

    private ConnectorUpdate updateProperties;

    public Connector create() {
        this.innerObject = serviceManager.serviceClient()
            .getConnectors()
            .createOrUpdate(connectorName, this.innerModel(), Context.NONE);
        return this;
    }

    public Connector create(Context context) {
        this.innerObject
            = serviceManager.serviceClient().getConnectors().createOrUpdate(connectorName, this.innerModel(), context);
        return this;
    }

    ConnectorImpl(String name, com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager) {
        this.innerObject = new ConnectorInner();
        this.serviceManager = serviceManager;
        this.connectorName = name;
    }

    public ConnectorImpl update() {
        this.updateProperties = new ConnectorUpdate();
        return this;
    }

    public Connector apply() {
        this.innerObject = serviceManager.serviceClient()
            .getConnectors()
            .updateWithResponse(connectorName, updateProperties, Context.NONE)
            .getValue();
        return this;
    }

    public Connector apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getConnectors()
            .updateWithResponse(connectorName, updateProperties, context)
            .getValue();
        return this;
    }

    ConnectorImpl(ConnectorInner innerObject,
        com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.connectorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "connectors");
    }

    public Connector refresh() {
        this.innerObject
            = serviceManager.serviceClient().getConnectors().getWithResponse(connectorName, Context.NONE).getValue();
        return this;
    }

    public Connector refresh(Context context) {
        this.innerObject
            = serviceManager.serviceClient().getConnectors().getWithResponse(connectorName, context).getValue();
        return this;
    }

    public ConnectorImpl withProperties(ConnectorProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    public ConnectorImpl withProperties(ConnectorUpdateProperties properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }
}
