// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.impactreporting.fluent.ConnectorsClient;
import com.azure.resourcemanager.impactreporting.fluent.models.ConnectorInner;
import com.azure.resourcemanager.impactreporting.models.Connector;
import com.azure.resourcemanager.impactreporting.models.Connectors;

public final class ConnectorsImpl implements Connectors {
    private static final ClientLogger LOGGER = new ClientLogger(ConnectorsImpl.class);

    private final ConnectorsClient innerClient;

    private final com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager;

    public ConnectorsImpl(ConnectorsClient innerClient,
        com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<Connector> getWithResponse(String connectorName, Context context) {
        Response<ConnectorInner> inner = this.serviceClient().getWithResponse(connectorName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ConnectorImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Connector get(String connectorName) {
        ConnectorInner inner = this.serviceClient().get(connectorName);
        if (inner != null) {
            return new ConnectorImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String connectorName, Context context) {
        return this.serviceClient().deleteWithResponse(connectorName, context);
    }

    public void delete(String connectorName) {
        this.serviceClient().delete(connectorName);
    }

    public PagedIterable<Connector> list() {
        PagedIterable<ConnectorInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConnectorImpl(inner1, this.manager()));
    }

    public PagedIterable<Connector> list(Context context) {
        PagedIterable<ConnectorInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConnectorImpl(inner1, this.manager()));
    }

    public Connector getById(String id) {
        String connectorName = ResourceManagerUtils.getValueFromIdByName(id, "connectors");
        if (connectorName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'connectors'.", id)));
        }
        return this.getWithResponse(connectorName, Context.NONE).getValue();
    }

    public Response<Connector> getByIdWithResponse(String id, Context context) {
        String connectorName = ResourceManagerUtils.getValueFromIdByName(id, "connectors");
        if (connectorName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'connectors'.", id)));
        }
        return this.getWithResponse(connectorName, context);
    }

    public void deleteById(String id) {
        String connectorName = ResourceManagerUtils.getValueFromIdByName(id, "connectors");
        if (connectorName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'connectors'.", id)));
        }
        this.deleteWithResponse(connectorName, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String connectorName = ResourceManagerUtils.getValueFromIdByName(id, "connectors");
        if (connectorName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'connectors'.", id)));
        }
        return this.deleteWithResponse(connectorName, context);
    }

    private ConnectorsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.impactreporting.ImpactReportingManager manager() {
        return this.serviceManager;
    }

    public ConnectorImpl define(String name) {
        return new ConnectorImpl(name, this.manager());
    }
}
