// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.impactreporting.fluent.ImpactCategoriesClient;
import com.azure.resourcemanager.impactreporting.fluent.models.ImpactCategoryInner;
import com.azure.resourcemanager.impactreporting.models.ImpactCategories;
import com.azure.resourcemanager.impactreporting.models.ImpactCategory;

public final class ImpactCategoriesImpl implements ImpactCategories {
    private static final ClientLogger LOGGER = new ClientLogger(ImpactCategoriesImpl.class);

    private final ImpactCategoriesClient innerClient;

    private final com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager;

    public ImpactCategoriesImpl(ImpactCategoriesClient innerClient,
        com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<ImpactCategory> getWithResponse(String impactCategoryName, Context context) {
        Response<ImpactCategoryInner> inner = this.serviceClient().getWithResponse(impactCategoryName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ImpactCategoryImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ImpactCategory get(String impactCategoryName) {
        ImpactCategoryInner inner = this.serviceClient().get(impactCategoryName);
        if (inner != null) {
            return new ImpactCategoryImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<ImpactCategory> list(String resourceType) {
        PagedIterable<ImpactCategoryInner> inner = this.serviceClient().list(resourceType);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ImpactCategoryImpl(inner1, this.manager()));
    }

    public PagedIterable<ImpactCategory> list(String resourceType, String categoryName, Context context) {
        PagedIterable<ImpactCategoryInner> inner = this.serviceClient().list(resourceType, categoryName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ImpactCategoryImpl(inner1, this.manager()));
    }

    private ImpactCategoriesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.impactreporting.ImpactReportingManager manager() {
        return this.serviceManager;
    }
}
