// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.impactreporting.fluent.InsightsClient;
import com.azure.resourcemanager.impactreporting.fluent.models.InsightInner;
import com.azure.resourcemanager.impactreporting.models.Insight;
import com.azure.resourcemanager.impactreporting.models.Insights;

public final class InsightsImpl implements Insights {
    private static final ClientLogger LOGGER = new ClientLogger(InsightsImpl.class);

    private final InsightsClient innerClient;

    private final com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager;

    public InsightsImpl(InsightsClient innerClient,
        com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<Insight> getWithResponse(String workloadImpactName, String insightName, Context context) {
        Response<InsightInner> inner = this.serviceClient().getWithResponse(workloadImpactName, insightName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new InsightImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Insight get(String workloadImpactName, String insightName) {
        InsightInner inner = this.serviceClient().get(workloadImpactName, insightName);
        if (inner != null) {
            return new InsightImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<Insight> listBySubscription(String workloadImpactName) {
        PagedIterable<InsightInner> inner = this.serviceClient().listBySubscription(workloadImpactName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InsightImpl(inner1, this.manager()));
    }

    public PagedIterable<Insight> listBySubscription(String workloadImpactName, Context context) {
        PagedIterable<InsightInner> inner = this.serviceClient().listBySubscription(workloadImpactName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InsightImpl(inner1, this.manager()));
    }

    public Response<Void> deleteByResourceGroupWithResponse(String workloadImpactName, String insightName,
        Context context) {
        return this.serviceClient().deleteWithResponse(workloadImpactName, insightName, context);
    }

    public void deleteByResourceGroup(String workloadImpactName, String insightName) {
        this.serviceClient().delete(workloadImpactName, insightName);
    }

    public Insight getById(String id) {
        String workloadImpactName = ResourceManagerUtils.getValueFromIdByName(id, "workloadImpacts");
        if (workloadImpactName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workloadImpacts'.", id)));
        }
        String insightName = ResourceManagerUtils.getValueFromIdByName(id, "insights");
        if (insightName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'insights'.", id)));
        }
        return this.getWithResponse(workloadImpactName, insightName, Context.NONE).getValue();
    }

    public Response<Insight> getByIdWithResponse(String id, Context context) {
        String workloadImpactName = ResourceManagerUtils.getValueFromIdByName(id, "workloadImpacts");
        if (workloadImpactName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workloadImpacts'.", id)));
        }
        String insightName = ResourceManagerUtils.getValueFromIdByName(id, "insights");
        if (insightName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'insights'.", id)));
        }
        return this.getWithResponse(workloadImpactName, insightName, context);
    }

    public void deleteById(String id) {
        String workloadImpactName = ResourceManagerUtils.getValueFromIdByName(id, "workloadImpacts");
        if (workloadImpactName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workloadImpacts'.", id)));
        }
        String insightName = ResourceManagerUtils.getValueFromIdByName(id, "insights");
        if (insightName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'insights'.", id)));
        }
        this.deleteByResourceGroupWithResponse(workloadImpactName, insightName, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String workloadImpactName = ResourceManagerUtils.getValueFromIdByName(id, "workloadImpacts");
        if (workloadImpactName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workloadImpacts'.", id)));
        }
        String insightName = ResourceManagerUtils.getValueFromIdByName(id, "insights");
        if (insightName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'insights'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(workloadImpactName, insightName, context);
    }

    private InsightsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.impactreporting.ImpactReportingManager manager() {
        return this.serviceManager;
    }

    public InsightImpl define(String name) {
        return new InsightImpl(name, this.manager());
    }
}
