// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.impactreporting.fluent.WorkloadImpactsClient;
import com.azure.resourcemanager.impactreporting.fluent.models.WorkloadImpactInner;
import com.azure.resourcemanager.impactreporting.models.WorkloadImpact;
import com.azure.resourcemanager.impactreporting.models.WorkloadImpacts;

public final class WorkloadImpactsImpl implements WorkloadImpacts {
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadImpactsImpl.class);

    private final WorkloadImpactsClient innerClient;

    private final com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager;

    public WorkloadImpactsImpl(WorkloadImpactsClient innerClient,
        com.azure.resourcemanager.impactreporting.ImpactReportingManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<WorkloadImpact> getWithResponse(String workloadImpactName, Context context) {
        Response<WorkloadImpactInner> inner = this.serviceClient().getWithResponse(workloadImpactName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new WorkloadImpactImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public WorkloadImpact get(String workloadImpactName) {
        WorkloadImpactInner inner = this.serviceClient().get(workloadImpactName);
        if (inner != null) {
            return new WorkloadImpactImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String workloadImpactName, Context context) {
        return this.serviceClient().deleteWithResponse(workloadImpactName, context);
    }

    public void delete(String workloadImpactName) {
        this.serviceClient().delete(workloadImpactName);
    }

    public PagedIterable<WorkloadImpact> list() {
        PagedIterable<WorkloadImpactInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkloadImpactImpl(inner1, this.manager()));
    }

    public PagedIterable<WorkloadImpact> list(Context context) {
        PagedIterable<WorkloadImpactInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkloadImpactImpl(inner1, this.manager()));
    }

    public WorkloadImpact getById(String id) {
        String workloadImpactName = ResourceManagerUtils.getValueFromIdByName(id, "workloadImpacts");
        if (workloadImpactName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workloadImpacts'.", id)));
        }
        return this.getWithResponse(workloadImpactName, Context.NONE).getValue();
    }

    public Response<WorkloadImpact> getByIdWithResponse(String id, Context context) {
        String workloadImpactName = ResourceManagerUtils.getValueFromIdByName(id, "workloadImpacts");
        if (workloadImpactName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workloadImpacts'.", id)));
        }
        return this.getWithResponse(workloadImpactName, context);
    }

    public void deleteById(String id) {
        String workloadImpactName = ResourceManagerUtils.getValueFromIdByName(id, "workloadImpacts");
        if (workloadImpactName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workloadImpacts'.", id)));
        }
        this.deleteWithResponse(workloadImpactName, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String workloadImpactName = ResourceManagerUtils.getValueFromIdByName(id, "workloadImpacts");
        if (workloadImpactName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workloadImpacts'.", id)));
        }
        return this.deleteWithResponse(workloadImpactName, context);
    }

    private WorkloadImpactsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.impactreporting.ImpactReportingManager manager() {
        return this.serviceManager;
    }

    public WorkloadImpactImpl define(String name) {
        return new WorkloadImpactImpl(name, this.manager());
    }
}
