// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Client incident details ex: incidentId , incident source.
 */
@Fluent
public final class ClientIncidentDetails implements JsonSerializable<ClientIncidentDetails> {
    /*
     * Client incident id. ex : id of the incident created to investigate and address the impact if any.
     */
    private String clientIncidentId;

    /*
     * Client incident source. ex : source system name where the incident is created
     */
    private IncidentSource clientIncidentSource;

    /**
     * Creates an instance of ClientIncidentDetails class.
     */
    public ClientIncidentDetails() {
    }

    /**
     * Get the clientIncidentId property: Client incident id. ex : id of the incident created to investigate and address
     * the impact if any.
     * 
     * @return the clientIncidentId value.
     */
    public String clientIncidentId() {
        return this.clientIncidentId;
    }

    /**
     * Set the clientIncidentId property: Client incident id. ex : id of the incident created to investigate and address
     * the impact if any.
     * 
     * @param clientIncidentId the clientIncidentId value to set.
     * @return the ClientIncidentDetails object itself.
     */
    public ClientIncidentDetails withClientIncidentId(String clientIncidentId) {
        this.clientIncidentId = clientIncidentId;
        return this;
    }

    /**
     * Get the clientIncidentSource property: Client incident source. ex : source system name where the incident is
     * created.
     * 
     * @return the clientIncidentSource value.
     */
    public IncidentSource clientIncidentSource() {
        return this.clientIncidentSource;
    }

    /**
     * Set the clientIncidentSource property: Client incident source. ex : source system name where the incident is
     * created.
     * 
     * @param clientIncidentSource the clientIncidentSource value to set.
     * @return the ClientIncidentDetails object itself.
     */
    public ClientIncidentDetails withClientIncidentSource(IncidentSource clientIncidentSource) {
        this.clientIncidentSource = clientIncidentSource;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientIncidentId", this.clientIncidentId);
        jsonWriter.writeStringField("clientIncidentSource",
            this.clientIncidentSource == null ? null : this.clientIncidentSource.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClientIncidentDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClientIncidentDetails if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClientIncidentDetails.
     */
    public static ClientIncidentDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClientIncidentDetails deserializedClientIncidentDetails = new ClientIncidentDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientIncidentId".equals(fieldName)) {
                    deserializedClientIncidentDetails.clientIncidentId = reader.getString();
                } else if ("clientIncidentSource".equals(fieldName)) {
                    deserializedClientIncidentDetails.clientIncidentSource
                        = IncidentSource.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClientIncidentDetails;
        });
    }
}
