// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Degree of confidence on the impact being a platform issue.
 */
public final class ConfidenceLevel extends ExpandableStringEnum<ConfidenceLevel> {
    /**
     * Low confidence on azure being the source of impact.
     */
    public static final ConfidenceLevel LOW = fromString("Low");

    /**
     * Medium confidence on azure being the source of impact.
     */
    public static final ConfidenceLevel MEDIUM = fromString("Medium");

    /**
     * High confidence on azure being the source of impact.
     */
    public static final ConfidenceLevel HIGH = fromString("High");

    /**
     * Creates a new instance of ConfidenceLevel value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ConfidenceLevel() {
    }

    /**
     * Creates or finds a ConfidenceLevel from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ConfidenceLevel.
     */
    public static ConfidenceLevel fromString(String name) {
        return fromString(name, ConfidenceLevel.class);
    }

    /**
     * Gets known ConfidenceLevel values.
     * 
     * @return known ConfidenceLevel values.
     */
    public static Collection<ConfidenceLevel> values() {
        return values(ConfidenceLevel.class);
    }
}
