// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details about connectivity issue. Applicable when root resource causing the issue is not identified. For example,
 * when a VM is impacted due to a network issue, the impacted resource could be VM or the network. In such cases, the
 * connectivity field will have the details about both VM and network.
 */
@Fluent
public final class Connectivity implements JsonSerializable<Connectivity> {
    /*
     * Protocol used for the connection
     */
    private Protocol protocol;

    /*
     * Port number for the connection
     */
    private Integer port;

    /*
     * Source from which the connection was attempted
     */
    private SourceOrTarget source;

    /*
     * target which connection was attempted
     */
    private SourceOrTarget target;

    /**
     * Creates an instance of Connectivity class.
     */
    public Connectivity() {
    }

    /**
     * Get the protocol property: Protocol used for the connection.
     * 
     * @return the protocol value.
     */
    public Protocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: Protocol used for the connection.
     * 
     * @param protocol the protocol value to set.
     * @return the Connectivity object itself.
     */
    public Connectivity withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the port property: Port number for the connection.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: Port number for the connection.
     * 
     * @param port the port value to set.
     * @return the Connectivity object itself.
     */
    public Connectivity withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the source property: Source from which the connection was attempted.
     * 
     * @return the source value.
     */
    public SourceOrTarget source() {
        return this.source;
    }

    /**
     * Set the source property: Source from which the connection was attempted.
     * 
     * @param source the source value to set.
     * @return the Connectivity object itself.
     */
    public Connectivity withSource(SourceOrTarget source) {
        this.source = source;
        return this;
    }

    /**
     * Get the target property: target which connection was attempted.
     * 
     * @return the target value.
     */
    public SourceOrTarget target() {
        return this.target;
    }

    /**
     * Set the target property: target which connection was attempted.
     * 
     * @param target the target value to set.
     * @return the Connectivity object itself.
     */
    public Connectivity withTarget(SourceOrTarget target) {
        this.target = target;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (source() != null) {
            source().validate();
        }
        if (target() != null) {
            target().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeNumberField("port", this.port);
        jsonWriter.writeJsonField("source", this.source);
        jsonWriter.writeJsonField("target", this.target);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Connectivity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Connectivity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Connectivity.
     */
    public static Connectivity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Connectivity deserializedConnectivity = new Connectivity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("protocol".equals(fieldName)) {
                    deserializedConnectivity.protocol = Protocol.fromString(reader.getString());
                } else if ("port".equals(fieldName)) {
                    deserializedConnectivity.port = reader.getNullable(JsonReader::getInt);
                } else if ("source".equals(fieldName)) {
                    deserializedConnectivity.source = SourceOrTarget.fromJson(reader);
                } else if ("target".equals(fieldName)) {
                    deserializedConnectivity.target = SourceOrTarget.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivity;
        });
    }
}
