// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Details of the Connector.
 */
@Fluent
public final class ConnectorProperties implements JsonSerializable<ConnectorProperties> {
    /*
     * Resource provisioning state.
     */
    private ProvisioningState provisioningState;

    /*
     * unique id of the connector.
     */
    private String connectorId;

    /*
     * tenant id of this connector
     */
    private String tenantId;

    /*
     * connector type
     */
    private Platform connectorType;

    /*
     * last run time stamp of this connector in UTC time zone
     */
    private OffsetDateTime lastRunTimeStamp;

    /**
     * Creates an instance of ConnectorProperties class.
     */
    public ConnectorProperties() {
    }

    /**
     * Get the provisioningState property: Resource provisioning state.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the connectorId property: unique id of the connector.
     * 
     * @return the connectorId value.
     */
    public String connectorId() {
        return this.connectorId;
    }

    /**
     * Get the tenantId property: tenant id of this connector.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the connectorType property: connector type.
     * 
     * @return the connectorType value.
     */
    public Platform connectorType() {
        return this.connectorType;
    }

    /**
     * Set the connectorType property: connector type.
     * 
     * @param connectorType the connectorType value to set.
     * @return the ConnectorProperties object itself.
     */
    public ConnectorProperties withConnectorType(Platform connectorType) {
        this.connectorType = connectorType;
        return this;
    }

    /**
     * Get the lastRunTimeStamp property: last run time stamp of this connector in UTC time zone.
     * 
     * @return the lastRunTimeStamp value.
     */
    public OffsetDateTime lastRunTimeStamp() {
        return this.lastRunTimeStamp;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectorType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectorType in model ConnectorProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectorProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectorType", this.connectorType == null ? null : this.connectorType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectorProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectorProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectorProperties.
     */
    public static ConnectorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectorProperties deserializedConnectorProperties = new ConnectorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectorId".equals(fieldName)) {
                    deserializedConnectorProperties.connectorId = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedConnectorProperties.tenantId = reader.getString();
                } else if ("connectorType".equals(fieldName)) {
                    deserializedConnectorProperties.connectorType = Platform.fromString(reader.getString());
                } else if ("lastRunTimeStamp".equals(fieldName)) {
                    deserializedConnectorProperties.lastRunTimeStamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedConnectorProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectorProperties;
        });
    }
}
