// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The updatable properties of the Connector.
 */
@Fluent
public final class ConnectorUpdateProperties implements JsonSerializable<ConnectorUpdateProperties> {
    /*
     * connector type
     */
    private Platform connectorType;

    /**
     * Creates an instance of ConnectorUpdateProperties class.
     */
    public ConnectorUpdateProperties() {
    }

    /**
     * Get the connectorType property: connector type.
     * 
     * @return the connectorType value.
     */
    public Platform connectorType() {
        return this.connectorType;
    }

    /**
     * Set the connectorType property: connector type.
     * 
     * @param connectorType the connectorType value to set.
     * @return the ConnectorUpdateProperties object itself.
     */
    public ConnectorUpdateProperties withConnectorType(Platform connectorType) {
        this.connectorType = connectorType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectorType", this.connectorType == null ? null : this.connectorType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectorUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectorUpdateProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectorUpdateProperties.
     */
    public static ConnectorUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectorUpdateProperties deserializedConnectorUpdateProperties = new ConnectorUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectorType".equals(fieldName)) {
                    deserializedConnectorUpdateProperties.connectorType = Platform.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectorUpdateProperties;
        });
    }
}
