// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Article details of the insight like title, description etc.
 */
@Fluent
public final class Content implements JsonSerializable<Content> {
    /*
     * Title of the insight
     */
    private String title;

    /*
     * Description of the insight
     */
    private String description;

    /**
     * Creates an instance of Content class.
     */
    public Content() {
    }

    /**
     * Get the title property: Title of the insight.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Title of the insight.
     * 
     * @param title the title value to set.
     * @return the Content object itself.
     */
    public Content withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the description property: Description of the insight.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the insight.
     * 
     * @param description the description value to set.
     * @return the Content object itself.
     */
    public Content withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (title() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property title in model Content"));
        }
        if (description() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property description in model Content"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(Content.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Content from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Content if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Content.
     */
    public static Content fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Content deserializedContent = new Content();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("title".equals(fieldName)) {
                    deserializedContent.title = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedContent.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContent;
        });
    }
}
