// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * ARM error code and error message associated with the impact.
 */
@Fluent
public final class ErrorDetailProperties implements JsonSerializable<ErrorDetailProperties> {
    /*
     * ARM Error code associated with the impact.
     */
    private String errorCode;

    /*
     * ARM Error Message associated with the impact
     */
    private String errorMessage;

    /**
     * Creates an instance of ErrorDetailProperties class.
     */
    public ErrorDetailProperties() {
    }

    /**
     * Get the errorCode property: ARM Error code associated with the impact.
     * 
     * @return the errorCode value.
     */
    public String errorCode() {
        return this.errorCode;
    }

    /**
     * Set the errorCode property: ARM Error code associated with the impact.
     * 
     * @param errorCode the errorCode value to set.
     * @return the ErrorDetailProperties object itself.
     */
    public ErrorDetailProperties withErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    /**
     * Get the errorMessage property: ARM Error Message associated with the impact.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Set the errorMessage property: ARM Error Message associated with the impact.
     * 
     * @param errorMessage the errorMessage value to set.
     * @return the ErrorDetailProperties object itself.
     */
    public ErrorDetailProperties withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ErrorDetailProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ErrorDetailProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ErrorDetailProperties.
     */
    public static ErrorDetailProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ErrorDetailProperties deserializedErrorDetailProperties = new ErrorDetailProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("errorCode".equals(fieldName)) {
                    deserializedErrorDetailProperties.errorCode = reader.getString();
                } else if ("errorMessage".equals(fieldName)) {
                    deserializedErrorDetailProperties.errorMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedErrorDetailProperties;
        });
    }
}
