// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Max and Min Threshold values for the metric.
 */
@Fluent
public final class ExpectedValueRange implements JsonSerializable<ExpectedValueRange> {
    /*
     * Min threshold value for the metric
     */
    private double min;

    /*
     * Max threshold value for the metric
     */
    private double max;

    /**
     * Creates an instance of ExpectedValueRange class.
     */
    public ExpectedValueRange() {
    }

    /**
     * Get the min property: Min threshold value for the metric.
     * 
     * @return the min value.
     */
    public double min() {
        return this.min;
    }

    /**
     * Set the min property: Min threshold value for the metric.
     * 
     * @param min the min value to set.
     * @return the ExpectedValueRange object itself.
     */
    public ExpectedValueRange withMin(double min) {
        this.min = min;
        return this;
    }

    /**
     * Get the max property: Max threshold value for the metric.
     * 
     * @return the max value.
     */
    public double max() {
        return this.max;
    }

    /**
     * Set the max property: Max threshold value for the metric.
     * 
     * @param max the max value to set.
     * @return the ExpectedValueRange object itself.
     */
    public ExpectedValueRange withMax(double max) {
        this.max = max;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("min", this.min);
        jsonWriter.writeDoubleField("max", this.max);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpectedValueRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpectedValueRange if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExpectedValueRange.
     */
    public static ExpectedValueRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpectedValueRange deserializedExpectedValueRange = new ExpectedValueRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("min".equals(fieldName)) {
                    deserializedExpectedValueRange.min = reader.getDouble();
                } else if ("max".equals(fieldName)) {
                    deserializedExpectedValueRange.max = reader.getDouble();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpectedValueRange;
        });
    }
}
