// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of ImpactCategories.
 */
public interface ImpactCategories {
    /**
     * Get a ImpactCategory.
     * 
     * @param impactCategoryName Name of the impact category.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a ImpactCategory along with {@link Response}.
     */
    Response<ImpactCategory> getWithResponse(String impactCategoryName, Context context);

    /**
     * Get a ImpactCategory.
     * 
     * @param impactCategoryName Name of the impact category.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a ImpactCategory.
     */
    ImpactCategory get(String impactCategoryName);

    /**
     * List ImpactCategory resources by subscription.
     * 
     * @param resourceType Filter by resource type.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ImpactCategory list operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ImpactCategory> list(String resourceType);

    /**
     * List ImpactCategory resources by subscription.
     * 
     * @param resourceType Filter by resource type.
     * @param categoryName Filter by category name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a ImpactCategory list operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ImpactCategory> list(String resourceType, String categoryName, Context context);
}
