// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Impact category properties.
 */
@Immutable
public final class ImpactCategoryProperties implements JsonSerializable<ImpactCategoryProperties> {
    /*
     * Resource provisioning state.
     */
    private ProvisioningState provisioningState;

    /*
     * Unique ID of the category
     */
    private String categoryId;

    /*
     * Unique ID of the parent category
     */
    private String parentCategoryId;

    /*
     * Description of the category
     */
    private String description;

    /*
     * The workloadImpact properties which are required when reporting with the impact category
     */
    private List<RequiredImpactProperties> requiredImpactProperties;

    /**
     * Creates an instance of ImpactCategoryProperties class.
     */
    private ImpactCategoryProperties() {
    }

    /**
     * Get the provisioningState property: Resource provisioning state.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the categoryId property: Unique ID of the category.
     * 
     * @return the categoryId value.
     */
    public String categoryId() {
        return this.categoryId;
    }

    /**
     * Get the parentCategoryId property: Unique ID of the parent category.
     * 
     * @return the parentCategoryId value.
     */
    public String parentCategoryId() {
        return this.parentCategoryId;
    }

    /**
     * Get the description property: Description of the category.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the requiredImpactProperties property: The workloadImpact properties which are required when reporting with
     * the impact category.
     * 
     * @return the requiredImpactProperties value.
     */
    public List<RequiredImpactProperties> requiredImpactProperties() {
        return this.requiredImpactProperties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (categoryId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property categoryId in model ImpactCategoryProperties"));
        }
        if (requiredImpactProperties() != null) {
            requiredImpactProperties().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImpactCategoryProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("categoryId", this.categoryId);
        jsonWriter.writeStringField("parentCategoryId", this.parentCategoryId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("requiredImpactProperties", this.requiredImpactProperties,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImpactCategoryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImpactCategoryProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImpactCategoryProperties.
     */
    public static ImpactCategoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImpactCategoryProperties deserializedImpactCategoryProperties = new ImpactCategoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("categoryId".equals(fieldName)) {
                    deserializedImpactCategoryProperties.categoryId = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedImpactCategoryProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("parentCategoryId".equals(fieldName)) {
                    deserializedImpactCategoryProperties.parentCategoryId = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedImpactCategoryProperties.description = reader.getString();
                } else if ("requiredImpactProperties".equals(fieldName)) {
                    List<RequiredImpactProperties> requiredImpactProperties
                        = reader.readArray(reader1 -> RequiredImpactProperties.fromJson(reader1));
                    deserializedImpactCategoryProperties.requiredImpactProperties = requiredImpactProperties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImpactCategoryProperties;
        });
    }
}
