// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * details of of the impact for which insight has been generated.
 */
@Fluent
public final class ImpactDetails implements JsonSerializable<ImpactDetails> {
    /*
     * List of impacted Azure resources.
     */
    private String impactedResourceId;

    /*
     * Time at which impact was started according to reported impact.
     */
    private OffsetDateTime startTime;

    /*
     * Time at which impact was ended according to reported impact.
     */
    private OffsetDateTime endTime;

    /*
     * Azure Id of the impact.
     */
    private String impactId;

    /**
     * Creates an instance of ImpactDetails class.
     */
    public ImpactDetails() {
    }

    /**
     * Get the impactedResourceId property: List of impacted Azure resources.
     * 
     * @return the impactedResourceId value.
     */
    public String impactedResourceId() {
        return this.impactedResourceId;
    }

    /**
     * Set the impactedResourceId property: List of impacted Azure resources.
     * 
     * @param impactedResourceId the impactedResourceId value to set.
     * @return the ImpactDetails object itself.
     */
    public ImpactDetails withImpactedResourceId(String impactedResourceId) {
        this.impactedResourceId = impactedResourceId;
        return this;
    }

    /**
     * Get the startTime property: Time at which impact was started according to reported impact.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Time at which impact was started according to reported impact.
     * 
     * @param startTime the startTime value to set.
     * @return the ImpactDetails object itself.
     */
    public ImpactDetails withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: Time at which impact was ended according to reported impact.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: Time at which impact was ended according to reported impact.
     * 
     * @param endTime the endTime value to set.
     * @return the ImpactDetails object itself.
     */
    public ImpactDetails withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the impactId property: Azure Id of the impact.
     * 
     * @return the impactId value.
     */
    public String impactId() {
        return this.impactId;
    }

    /**
     * Set the impactId property: Azure Id of the impact.
     * 
     * @param impactId the impactId value to set.
     * @return the ImpactDetails object itself.
     */
    public ImpactDetails withImpactId(String impactId) {
        this.impactId = impactId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (impactedResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property impactedResourceId in model ImpactDetails"));
        }
        if (startTime() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property startTime in model ImpactDetails"));
        }
        if (impactId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property impactId in model ImpactDetails"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImpactDetails.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("impactedResourceId", this.impactedResourceId);
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("impactId", this.impactId);
        jsonWriter.writeStringField("endTime",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImpactDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImpactDetails if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImpactDetails.
     */
    public static ImpactDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImpactDetails deserializedImpactDetails = new ImpactDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("impactedResourceId".equals(fieldName)) {
                    deserializedImpactDetails.impactedResourceId = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedImpactDetails.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("impactId".equals(fieldName)) {
                    deserializedImpactDetails.impactId = reader.getString();
                } else if ("endTime".equals(fieldName)) {
                    deserializedImpactDetails.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImpactDetails;
        });
    }
}
