// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * List of incident interfaces.
 */
public final class IncidentSource extends ExpandableStringEnum<IncidentSource> {
    /**
     * When source of Incident is AzureDevops.
     */
    public static final IncidentSource AZURE_DEVOPS = fromString("AzureDevops");

    /**
     * When source of Incident is Microsoft ICM.
     */
    public static final IncidentSource ICM = fromString("ICM");

    /**
     * When source of Incident is Jira.
     */
    public static final IncidentSource JIRA = fromString("Jira");

    /**
     * When source of Incident is ServiceNow.
     */
    public static final IncidentSource SERVICE_NOW = fromString("ServiceNow");

    /**
     * When source of Incident is Other.
     */
    public static final IncidentSource OTHER = fromString("Other");

    /**
     * Creates a new instance of IncidentSource value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IncidentSource() {
    }

    /**
     * Creates or finds a IncidentSource from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IncidentSource.
     */
    public static IncidentSource fromString(String name) {
        return fromString(name, IncidentSource.class);
    }

    /**
     * Gets known IncidentSource values.
     * 
     * @return known IncidentSource values.
     */
    public static Collection<IncidentSource> values() {
        return values(IncidentSource.class);
    }
}
