// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Impact category properties.
 */
@Fluent
public final class InsightProperties implements JsonSerializable<InsightProperties> {
    /*
     * Resource provisioning state.
     */
    private ProvisioningState provisioningState;

    /*
     * category of the insight.
     */
    private String category;

    /*
     * status of the insight. example resolved, repaired, other.
     */
    private String status;

    /*
     * Identifier of the event that has been correlated with this insight. This can be used to aggregate insights for
     * the same event.
     */
    private String eventId;

    /*
     * Identifier that can be used to group similar insights.
     */
    private String groupId;

    /*
     * Contains title & description for the insight
     */
    private Content content;

    /*
     * Time of the event, which has been correlated the impact.
     */
    private OffsetDateTime eventTime;

    /*
     * unique id of the insight.
     */
    private String insightUniqueId;

    /*
     * details of of the impact for which insight has been generated.
     */
    private ImpactDetails impact;

    /*
     * additional details of the insight.
     */
    private InsightPropertiesAdditionalDetails additionalDetails;

    /**
     * Creates an instance of InsightProperties class.
     */
    public InsightProperties() {
    }

    /**
     * Get the provisioningState property: Resource provisioning state.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the category property: category of the insight.
     * 
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Set the category property: category of the insight.
     * 
     * @param category the category value to set.
     * @return the InsightProperties object itself.
     */
    public InsightProperties withCategory(String category) {
        this.category = category;
        return this;
    }

    /**
     * Get the status property: status of the insight. example resolved, repaired, other.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: status of the insight. example resolved, repaired, other.
     * 
     * @param status the status value to set.
     * @return the InsightProperties object itself.
     */
    public InsightProperties withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the eventId property: Identifier of the event that has been correlated with this insight. This can be used to
     * aggregate insights for the same event.
     * 
     * @return the eventId value.
     */
    public String eventId() {
        return this.eventId;
    }

    /**
     * Set the eventId property: Identifier of the event that has been correlated with this insight. This can be used to
     * aggregate insights for the same event.
     * 
     * @param eventId the eventId value to set.
     * @return the InsightProperties object itself.
     */
    public InsightProperties withEventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    /**
     * Get the groupId property: Identifier that can be used to group similar insights.
     * 
     * @return the groupId value.
     */
    public String groupId() {
        return this.groupId;
    }

    /**
     * Set the groupId property: Identifier that can be used to group similar insights.
     * 
     * @param groupId the groupId value to set.
     * @return the InsightProperties object itself.
     */
    public InsightProperties withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
     * Get the content property: Contains title &amp; description for the insight.
     * 
     * @return the content value.
     */
    public Content content() {
        return this.content;
    }

    /**
     * Set the content property: Contains title &amp; description for the insight.
     * 
     * @param content the content value to set.
     * @return the InsightProperties object itself.
     */
    public InsightProperties withContent(Content content) {
        this.content = content;
        return this;
    }

    /**
     * Get the eventTime property: Time of the event, which has been correlated the impact.
     * 
     * @return the eventTime value.
     */
    public OffsetDateTime eventTime() {
        return this.eventTime;
    }

    /**
     * Set the eventTime property: Time of the event, which has been correlated the impact.
     * 
     * @param eventTime the eventTime value to set.
     * @return the InsightProperties object itself.
     */
    public InsightProperties withEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    /**
     * Get the insightUniqueId property: unique id of the insight.
     * 
     * @return the insightUniqueId value.
     */
    public String insightUniqueId() {
        return this.insightUniqueId;
    }

    /**
     * Set the insightUniqueId property: unique id of the insight.
     * 
     * @param insightUniqueId the insightUniqueId value to set.
     * @return the InsightProperties object itself.
     */
    public InsightProperties withInsightUniqueId(String insightUniqueId) {
        this.insightUniqueId = insightUniqueId;
        return this;
    }

    /**
     * Get the impact property: details of of the impact for which insight has been generated.
     * 
     * @return the impact value.
     */
    public ImpactDetails impact() {
        return this.impact;
    }

    /**
     * Set the impact property: details of of the impact for which insight has been generated.
     * 
     * @param impact the impact value to set.
     * @return the InsightProperties object itself.
     */
    public InsightProperties withImpact(ImpactDetails impact) {
        this.impact = impact;
        return this;
    }

    /**
     * Get the additionalDetails property: additional details of the insight.
     * 
     * @return the additionalDetails value.
     */
    public InsightPropertiesAdditionalDetails additionalDetails() {
        return this.additionalDetails;
    }

    /**
     * Set the additionalDetails property: additional details of the insight.
     * 
     * @param additionalDetails the additionalDetails value to set.
     * @return the InsightProperties object itself.
     */
    public InsightProperties withAdditionalDetails(InsightPropertiesAdditionalDetails additionalDetails) {
        this.additionalDetails = additionalDetails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (category() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property category in model InsightProperties"));
        }
        if (content() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property content in model InsightProperties"));
        } else {
            content().validate();
        }
        if (insightUniqueId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property insightUniqueId in model InsightProperties"));
        }
        if (impact() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property impact in model InsightProperties"));
        } else {
            impact().validate();
        }
        if (additionalDetails() != null) {
            additionalDetails().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(InsightProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeJsonField("content", this.content);
        jsonWriter.writeStringField("insightUniqueId", this.insightUniqueId);
        jsonWriter.writeJsonField("impact", this.impact);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("eventId", this.eventId);
        jsonWriter.writeStringField("groupId", this.groupId);
        jsonWriter.writeStringField("eventTime",
            this.eventTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.eventTime));
        jsonWriter.writeJsonField("additionalDetails", this.additionalDetails);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InsightProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InsightProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the InsightProperties.
     */
    public static InsightProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InsightProperties deserializedInsightProperties = new InsightProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("category".equals(fieldName)) {
                    deserializedInsightProperties.category = reader.getString();
                } else if ("content".equals(fieldName)) {
                    deserializedInsightProperties.content = Content.fromJson(reader);
                } else if ("insightUniqueId".equals(fieldName)) {
                    deserializedInsightProperties.insightUniqueId = reader.getString();
                } else if ("impact".equals(fieldName)) {
                    deserializedInsightProperties.impact = ImpactDetails.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedInsightProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    deserializedInsightProperties.status = reader.getString();
                } else if ("eventId".equals(fieldName)) {
                    deserializedInsightProperties.eventId = reader.getString();
                } else if ("groupId".equals(fieldName)) {
                    deserializedInsightProperties.groupId = reader.getString();
                } else if ("eventTime".equals(fieldName)) {
                    deserializedInsightProperties.eventTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("additionalDetails".equals(fieldName)) {
                    deserializedInsightProperties.additionalDetails
                        = InsightPropertiesAdditionalDetails.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInsightProperties;
        });
    }
}
