// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of Insights.
 */
public interface Insights {
    /**
     * Get Insight resources by workloadImpactName and insightName.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return insight resources by workloadImpactName and insightName along with {@link Response}.
     */
    Response<Insight> getWithResponse(String workloadImpactName, String insightName, Context context);

    /**
     * Get Insight resources by workloadImpactName and insightName.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return insight resources by workloadImpactName and insightName.
     */
    Insight get(String workloadImpactName, String insightName);

    /**
     * List Insight resources by workloadImpactName.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Insight list operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Insight> listBySubscription(String workloadImpactName);

    /**
     * List Insight resources by workloadImpactName.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a Insight list operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<Insight> listBySubscription(String workloadImpactName, Context context);

    /**
     * Delete Insight resource, This is Admin only operation.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByResourceGroupWithResponse(String workloadImpactName, String insightName, Context context);

    /**
     * Delete Insight resource, This is Admin only operation.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param insightName Name of the insight.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByResourceGroup(String workloadImpactName, String insightName);

    /**
     * Get Insight resources by workloadImpactName and insightName.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return insight resources by workloadImpactName and insightName along with {@link Response}.
     */
    Insight getById(String id);

    /**
     * Get Insight resources by workloadImpactName and insightName.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return insight resources by workloadImpactName and insightName along with {@link Response}.
     */
    Response<Insight> getByIdWithResponse(String id, Context context);

    /**
     * Delete Insight resource, This is Admin only operation.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Delete Insight resource, This is Admin only operation.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new Insight resource.
     * 
     * @param name resource name.
     * @return the first stage of the new Insight definition.
     */
    Insight.DefinitionStages.Blank define(String name);
}
