// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * List of unit of the metric.
 */
public final class MetricUnit extends ExpandableStringEnum<MetricUnit> {
    /**
     * When measurement is in ByteSeconds.
     */
    public static final MetricUnit BYTE_SECONDS = fromString("ByteSeconds");

    /**
     * When measurement is in Bytes.
     */
    public static final MetricUnit BYTES = fromString("Bytes");

    /**
     * When measurement is in BytesPerSecond.
     */
    public static final MetricUnit BYTES_PER_SECOND = fromString("BytesPerSecond");

    /**
     * When measurement is in Cores.
     */
    public static final MetricUnit CORES = fromString("Cores");

    /**
     * When measurement is in Count.
     */
    public static final MetricUnit COUNT = fromString("Count");

    /**
     * When measurement is in CountPerSecond.
     */
    public static final MetricUnit COUNT_PER_SECOND = fromString("CountPerSecond");

    /**
     * When measurement is in MilliCores.
     */
    public static final MetricUnit MILLI_CORES = fromString("MilliCores");

    /**
     * When measurement is in MilliSeconds.
     */
    public static final MetricUnit MILLI_SECONDS = fromString("MilliSeconds");

    /**
     * When measurement is in NanoCores.
     */
    public static final MetricUnit NANO_CORES = fromString("NanoCores");

    /**
     * When measurement is in Percent.
     */
    public static final MetricUnit PERCENT = fromString("Percent");

    /**
     * When measurement is in Seconds.
     */
    public static final MetricUnit SECONDS = fromString("Seconds");

    /**
     * When measurement is in Other than listed.
     */
    public static final MetricUnit OTHER = fromString("Other");

    /**
     * Creates a new instance of MetricUnit value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public MetricUnit() {
    }

    /**
     * Creates or finds a MetricUnit from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding MetricUnit.
     */
    public static MetricUnit fromString(String name) {
        return fromString(name, MetricUnit.class);
    }

    /**
     * Gets known MetricUnit values.
     * 
     * @return known MetricUnit values.
     */
    public static Collection<MetricUnit> values() {
        return values(MetricUnit.class);
    }
}
