// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details about impacted performance metrics. Applicable for performance related impact.
 */
@Fluent
public final class Performance implements JsonSerializable<Performance> {
    /*
     * Name of the Metric examples: Disk, IOPs, CPU, GPU, Memory, details can be found from /impactCategories API
     */
    private String metricName;

    /*
     * Threshold value for the metric
     */
    private Double expected;

    /*
     * Observed value for the metric
     */
    private Double actual;

    /*
     * Max and Min Threshold values for the metric
     */
    private ExpectedValueRange expectedValueRange;

    /*
     * Unit of the metric ex: Bytes, Percentage, Count, Seconds, Milliseconds, Bytes/Second, Count/Second, etc.., Other
     */
    private MetricUnit unit;

    /**
     * Creates an instance of Performance class.
     */
    public Performance() {
    }

    /**
     * Get the metricName property: Name of the Metric examples: Disk, IOPs, CPU, GPU, Memory, details can be found from
     * /impactCategories API.
     * 
     * @return the metricName value.
     */
    public String metricName() {
        return this.metricName;
    }

    /**
     * Set the metricName property: Name of the Metric examples: Disk, IOPs, CPU, GPU, Memory, details can be found from
     * /impactCategories API.
     * 
     * @param metricName the metricName value to set.
     * @return the Performance object itself.
     */
    public Performance withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    /**
     * Get the expected property: Threshold value for the metric.
     * 
     * @return the expected value.
     */
    public Double expected() {
        return this.expected;
    }

    /**
     * Set the expected property: Threshold value for the metric.
     * 
     * @param expected the expected value to set.
     * @return the Performance object itself.
     */
    public Performance withExpected(Double expected) {
        this.expected = expected;
        return this;
    }

    /**
     * Get the actual property: Observed value for the metric.
     * 
     * @return the actual value.
     */
    public Double actual() {
        return this.actual;
    }

    /**
     * Set the actual property: Observed value for the metric.
     * 
     * @param actual the actual value to set.
     * @return the Performance object itself.
     */
    public Performance withActual(Double actual) {
        this.actual = actual;
        return this;
    }

    /**
     * Get the expectedValueRange property: Max and Min Threshold values for the metric.
     * 
     * @return the expectedValueRange value.
     */
    public ExpectedValueRange expectedValueRange() {
        return this.expectedValueRange;
    }

    /**
     * Set the expectedValueRange property: Max and Min Threshold values for the metric.
     * 
     * @param expectedValueRange the expectedValueRange value to set.
     * @return the Performance object itself.
     */
    public Performance withExpectedValueRange(ExpectedValueRange expectedValueRange) {
        this.expectedValueRange = expectedValueRange;
        return this;
    }

    /**
     * Get the unit property: Unit of the metric ex: Bytes, Percentage, Count, Seconds, Milliseconds, Bytes/Second,
     * Count/Second, etc.., Other.
     * 
     * @return the unit value.
     */
    public MetricUnit unit() {
        return this.unit;
    }

    /**
     * Set the unit property: Unit of the metric ex: Bytes, Percentage, Count, Seconds, Milliseconds, Bytes/Second,
     * Count/Second, etc.., Other.
     * 
     * @param unit the unit value to set.
     * @return the Performance object itself.
     */
    public Performance withUnit(MetricUnit unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (expectedValueRange() != null) {
            expectedValueRange().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("metricName", this.metricName);
        jsonWriter.writeNumberField("expected", this.expected);
        jsonWriter.writeNumberField("actual", this.actual);
        jsonWriter.writeJsonField("expectedValueRange", this.expectedValueRange);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Performance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Performance if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the Performance.
     */
    public static Performance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Performance deserializedPerformance = new Performance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metricName".equals(fieldName)) {
                    deserializedPerformance.metricName = reader.getString();
                } else if ("expected".equals(fieldName)) {
                    deserializedPerformance.expected = reader.getNullable(JsonReader::getDouble);
                } else if ("actual".equals(fieldName)) {
                    deserializedPerformance.actual = reader.getNullable(JsonReader::getDouble);
                } else if ("expectedValueRange".equals(fieldName)) {
                    deserializedPerformance.expectedValueRange = ExpectedValueRange.fromJson(reader);
                } else if ("unit".equals(fieldName)) {
                    deserializedPerformance.unit = MetricUnit.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPerformance;
        });
    }
}
