// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * List of protocols.
 */
public final class Protocol extends ExpandableStringEnum<Protocol> {
    /**
     * When communication protocol is TCP.
     */
    public static final Protocol TCP = fromString("TCP");

    /**
     * When communication protocol is UDP.
     */
    public static final Protocol UDP = fromString("UDP");

    /**
     * When communication protocol is HTTP.
     */
    public static final Protocol HTTP = fromString("HTTP");

    /**
     * When communication protocol is HTTPS.
     */
    public static final Protocol HTTPS = fromString("HTTPS");

    /**
     * When communication protocol is RDP.
     */
    public static final Protocol RDP = fromString("RDP");

    /**
     * When communication protocol is FTP.
     */
    public static final Protocol FTP = fromString("FTP");

    /**
     * When communication protocol is SSH.
     */
    public static final Protocol SSH = fromString("SSH");

    /**
     * When communication protocol is Other.
     */
    public static final Protocol OTHER = fromString("Other");

    /**
     * Creates a new instance of Protocol value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Protocol() {
    }

    /**
     * Creates or finds a Protocol from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding Protocol.
     */
    public static Protocol fromString(String name) {
        return fromString(name, Protocol.class);
    }

    /**
     * Gets known Protocol values.
     * 
     * @return known Protocol values.
     */
    public static Collection<Protocol> values() {
        return values(Protocol.class);
    }
}
