// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Required impact properties.
 */
@Immutable
public final class RequiredImpactProperties implements JsonSerializable<RequiredImpactProperties> {
    /*
     * Name of the property
     */
    private String name;

    /*
     * Allowed values values for the property
     */
    private List<String> allowedValues;

    /**
     * Creates an instance of RequiredImpactProperties class.
     */
    private RequiredImpactProperties() {
    }

    /**
     * Get the name property: Name of the property.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the allowedValues property: Allowed values values for the property.
     * 
     * @return the allowedValues value.
     */
    public List<String> allowedValues() {
        return this.allowedValues;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model RequiredImpactProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RequiredImpactProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("allowedValues", this.allowedValues,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RequiredImpactProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RequiredImpactProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RequiredImpactProperties.
     */
    public static RequiredImpactProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RequiredImpactProperties deserializedRequiredImpactProperties = new RequiredImpactProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedRequiredImpactProperties.name = reader.getString();
                } else if ("allowedValues".equals(fieldName)) {
                    List<String> allowedValues = reader.readArray(reader1 -> reader1.getString());
                    deserializedRequiredImpactProperties.allowedValues = allowedValues;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRequiredImpactProperties;
        });
    }
}
