// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Resource details.
 */
@Fluent
public final class SourceOrTarget implements JsonSerializable<SourceOrTarget> {
    /*
     * Azure resource id, example
     * /subscription/{subscription}/resourceGroup/{rg}/Microsoft.compute/virtualMachine/{vmName}
     */
    private String azureResourceId;

    /**
     * Creates an instance of SourceOrTarget class.
     */
    public SourceOrTarget() {
    }

    /**
     * Get the azureResourceId property: Azure resource id, example
     * /subscription/{subscription}/resourceGroup/{rg}/Microsoft.compute/virtualMachine/{vmName}.
     * 
     * @return the azureResourceId value.
     */
    public String azureResourceId() {
        return this.azureResourceId;
    }

    /**
     * Set the azureResourceId property: Azure resource id, example
     * /subscription/{subscription}/resourceGroup/{rg}/Microsoft.compute/virtualMachine/{vmName}.
     * 
     * @param azureResourceId the azureResourceId value to set.
     * @return the SourceOrTarget object itself.
     */
    public SourceOrTarget withAzureResourceId(String azureResourceId) {
        this.azureResourceId = azureResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureResourceId", this.azureResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourceOrTarget from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourceOrTarget if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SourceOrTarget.
     */
    public static SourceOrTarget fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceOrTarget deserializedSourceOrTarget = new SourceOrTarget();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("azureResourceId".equals(fieldName)) {
                    deserializedSourceOrTarget.azureResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourceOrTarget;
        });
    }
}
