// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about the impacted workload.
 */
@Fluent
public final class Workload implements JsonSerializable<Workload> {
    /*
     * the scenario for the workload
     */
    private String context;

    /*
     * Tool used to interact with Azure. SDK, AzPortal, etc.., Other
     */
    private Toolset toolset;

    /**
     * Creates an instance of Workload class.
     */
    public Workload() {
    }

    /**
     * Get the context property: the scenario for the workload.
     * 
     * @return the context value.
     */
    public String context() {
        return this.context;
    }

    /**
     * Set the context property: the scenario for the workload.
     * 
     * @param context the context value to set.
     * @return the Workload object itself.
     */
    public Workload withContext(String context) {
        this.context = context;
        return this;
    }

    /**
     * Get the toolset property: Tool used to interact with Azure. SDK, AzPortal, etc.., Other.
     * 
     * @return the toolset value.
     */
    public Toolset toolset() {
        return this.toolset;
    }

    /**
     * Set the toolset property: Tool used to interact with Azure. SDK, AzPortal, etc.., Other.
     * 
     * @param toolset the toolset value to set.
     * @return the Workload object itself.
     */
    public Workload withToolset(Toolset toolset) {
        this.toolset = toolset;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("context", this.context);
        jsonWriter.writeStringField("toolset", this.toolset == null ? null : this.toolset.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Workload from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Workload if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Workload.
     */
    public static Workload fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Workload deserializedWorkload = new Workload();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("context".equals(fieldName)) {
                    deserializedWorkload.context = reader.getString();
                } else if ("toolset".equals(fieldName)) {
                    deserializedWorkload.toolset = Toolset.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkload;
        });
    }
}
