// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Workload impact properties.
 */
@Fluent
public final class WorkloadImpactProperties implements JsonSerializable<WorkloadImpactProperties> {
    /*
     * Resource provisioning state.
     */
    private ProvisioningState provisioningState;

    /*
     * Time at which impact was observed
     */
    private OffsetDateTime startDateTime;

    /*
     * Time at which impact has ended
     */
    private OffsetDateTime endDateTime;

    /*
     * Azure resource id of the impacted resource
     */
    private String impactedResourceId;

    /*
     * Unique ID of the impact (UUID)
     */
    private String impactUniqueId;

    /*
     * Time at which impact is reported
     */
    private OffsetDateTime reportedTimeUtc;

    /*
     * Category of the impact, details can found from /impactCategories API
     */
    private String impactCategory;

    /*
     * A detailed description of the impact
     */
    private String impactDescription;

    /*
     * The ARM correlation ids, this is important field for control plane related impacts
     */
    private List<String> armCorrelationIds;

    /*
     * Details about performance issue. Applicable for performance impacts.
     */
    private List<Performance> performance;

    /*
     * Details about connectivity issue. Applicable when root resource causing the issue is not identified. For example,
     * when a VM is impacted due to a network issue, the impacted resource is identified as the VM, but the root cause
     * is the network. In such cases, the connectivity field will have the details about the network issue
     */
    private Connectivity connectivity;

    /*
     * Additional fields related to impact, applicable fields per resource type are list under /impactCategories API
     */
    private WorkloadImpactPropertiesAdditionalProperties additionalProperties;

    /*
     * ARM error code and error message associated with the impact
     */
    private ErrorDetailProperties errorDetails;

    /*
     * Information about the impacted workload
     */
    private Workload workload;

    /*
     * Use this field to group impacts
     */
    private String impactGroupId;

    /*
     * Degree of confidence on the impact being a platform issue
     */
    private ConfidenceLevel confidenceLevel;

    /*
     * Client incident details ex: incidentId , incident source
     */
    private ClientIncidentDetails clientIncidentDetails;

    /**
     * Creates an instance of WorkloadImpactProperties class.
     */
    public WorkloadImpactProperties() {
    }

    /**
     * Get the provisioningState property: Resource provisioning state.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the startDateTime property: Time at which impact was observed.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: Time at which impact was observed.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the endDateTime property: Time at which impact has ended.
     * 
     * @return the endDateTime value.
     */
    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    /**
     * Set the endDateTime property: Time at which impact has ended.
     * 
     * @param endDateTime the endDateTime value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    /**
     * Get the impactedResourceId property: Azure resource id of the impacted resource.
     * 
     * @return the impactedResourceId value.
     */
    public String impactedResourceId() {
        return this.impactedResourceId;
    }

    /**
     * Set the impactedResourceId property: Azure resource id of the impacted resource.
     * 
     * @param impactedResourceId the impactedResourceId value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withImpactedResourceId(String impactedResourceId) {
        this.impactedResourceId = impactedResourceId;
        return this;
    }

    /**
     * Get the impactUniqueId property: Unique ID of the impact (UUID).
     * 
     * @return the impactUniqueId value.
     */
    public String impactUniqueId() {
        return this.impactUniqueId;
    }

    /**
     * Get the reportedTimeUtc property: Time at which impact is reported.
     * 
     * @return the reportedTimeUtc value.
     */
    public OffsetDateTime reportedTimeUtc() {
        return this.reportedTimeUtc;
    }

    /**
     * Get the impactCategory property: Category of the impact, details can found from /impactCategories API.
     * 
     * @return the impactCategory value.
     */
    public String impactCategory() {
        return this.impactCategory;
    }

    /**
     * Set the impactCategory property: Category of the impact, details can found from /impactCategories API.
     * 
     * @param impactCategory the impactCategory value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withImpactCategory(String impactCategory) {
        this.impactCategory = impactCategory;
        return this;
    }

    /**
     * Get the impactDescription property: A detailed description of the impact.
     * 
     * @return the impactDescription value.
     */
    public String impactDescription() {
        return this.impactDescription;
    }

    /**
     * Set the impactDescription property: A detailed description of the impact.
     * 
     * @param impactDescription the impactDescription value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withImpactDescription(String impactDescription) {
        this.impactDescription = impactDescription;
        return this;
    }

    /**
     * Get the armCorrelationIds property: The ARM correlation ids, this is important field for control plane related
     * impacts.
     * 
     * @return the armCorrelationIds value.
     */
    public List<String> armCorrelationIds() {
        return this.armCorrelationIds;
    }

    /**
     * Set the armCorrelationIds property: The ARM correlation ids, this is important field for control plane related
     * impacts.
     * 
     * @param armCorrelationIds the armCorrelationIds value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withArmCorrelationIds(List<String> armCorrelationIds) {
        this.armCorrelationIds = armCorrelationIds;
        return this;
    }

    /**
     * Get the performance property: Details about performance issue. Applicable for performance impacts.
     * 
     * @return the performance value.
     */
    public List<Performance> performance() {
        return this.performance;
    }

    /**
     * Set the performance property: Details about performance issue. Applicable for performance impacts.
     * 
     * @param performance the performance value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withPerformance(List<Performance> performance) {
        this.performance = performance;
        return this;
    }

    /**
     * Get the connectivity property: Details about connectivity issue. Applicable when root resource causing the issue
     * is not identified. For example, when a VM is impacted due to a network issue, the impacted resource is identified
     * as the VM, but the root cause is the network. In such cases, the connectivity field will have the details about
     * the network issue.
     * 
     * @return the connectivity value.
     */
    public Connectivity connectivity() {
        return this.connectivity;
    }

    /**
     * Set the connectivity property: Details about connectivity issue. Applicable when root resource causing the issue
     * is not identified. For example, when a VM is impacted due to a network issue, the impacted resource is identified
     * as the VM, but the root cause is the network. In such cases, the connectivity field will have the details about
     * the network issue.
     * 
     * @param connectivity the connectivity value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withConnectivity(Connectivity connectivity) {
        this.connectivity = connectivity;
        return this;
    }

    /**
     * Get the additionalProperties property: Additional fields related to impact, applicable fields per resource type
     * are list under /impactCategories API.
     * 
     * @return the additionalProperties value.
     */
    public WorkloadImpactPropertiesAdditionalProperties additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Additional fields related to impact, applicable fields per resource type
     * are list under /impactCategories API.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties
        withAdditionalProperties(WorkloadImpactPropertiesAdditionalProperties additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Get the errorDetails property: ARM error code and error message associated with the impact.
     * 
     * @return the errorDetails value.
     */
    public ErrorDetailProperties errorDetails() {
        return this.errorDetails;
    }

    /**
     * Set the errorDetails property: ARM error code and error message associated with the impact.
     * 
     * @param errorDetails the errorDetails value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withErrorDetails(ErrorDetailProperties errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    /**
     * Get the workload property: Information about the impacted workload.
     * 
     * @return the workload value.
     */
    public Workload workload() {
        return this.workload;
    }

    /**
     * Set the workload property: Information about the impacted workload.
     * 
     * @param workload the workload value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withWorkload(Workload workload) {
        this.workload = workload;
        return this;
    }

    /**
     * Get the impactGroupId property: Use this field to group impacts.
     * 
     * @return the impactGroupId value.
     */
    public String impactGroupId() {
        return this.impactGroupId;
    }

    /**
     * Set the impactGroupId property: Use this field to group impacts.
     * 
     * @param impactGroupId the impactGroupId value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withImpactGroupId(String impactGroupId) {
        this.impactGroupId = impactGroupId;
        return this;
    }

    /**
     * Get the confidenceLevel property: Degree of confidence on the impact being a platform issue.
     * 
     * @return the confidenceLevel value.
     */
    public ConfidenceLevel confidenceLevel() {
        return this.confidenceLevel;
    }

    /**
     * Set the confidenceLevel property: Degree of confidence on the impact being a platform issue.
     * 
     * @param confidenceLevel the confidenceLevel value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withConfidenceLevel(ConfidenceLevel confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        return this;
    }

    /**
     * Get the clientIncidentDetails property: Client incident details ex: incidentId , incident source.
     * 
     * @return the clientIncidentDetails value.
     */
    public ClientIncidentDetails clientIncidentDetails() {
        return this.clientIncidentDetails;
    }

    /**
     * Set the clientIncidentDetails property: Client incident details ex: incidentId , incident source.
     * 
     * @param clientIncidentDetails the clientIncidentDetails value to set.
     * @return the WorkloadImpactProperties object itself.
     */
    public WorkloadImpactProperties withClientIncidentDetails(ClientIncidentDetails clientIncidentDetails) {
        this.clientIncidentDetails = clientIncidentDetails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (startDateTime() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property startDateTime in model WorkloadImpactProperties"));
        }
        if (impactedResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property impactedResourceId in model WorkloadImpactProperties"));
        }
        if (impactCategory() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property impactCategory in model WorkloadImpactProperties"));
        }
        if (performance() != null) {
            performance().forEach(e -> e.validate());
        }
        if (connectivity() != null) {
            connectivity().validate();
        }
        if (additionalProperties() != null) {
            additionalProperties().validate();
        }
        if (errorDetails() != null) {
            errorDetails().validate();
        }
        if (workload() != null) {
            workload().validate();
        }
        if (clientIncidentDetails() != null) {
            clientIncidentDetails().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WorkloadImpactProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startDateTime",
            this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("impactedResourceId", this.impactedResourceId);
        jsonWriter.writeStringField("impactCategory", this.impactCategory);
        jsonWriter.writeStringField("endDateTime",
            this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeStringField("impactDescription", this.impactDescription);
        jsonWriter.writeArrayField("armCorrelationIds", this.armCorrelationIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("performance", this.performance, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("connectivity", this.connectivity);
        jsonWriter.writeJsonField("additionalProperties", this.additionalProperties);
        jsonWriter.writeJsonField("errorDetails", this.errorDetails);
        jsonWriter.writeJsonField("workload", this.workload);
        jsonWriter.writeStringField("impactGroupId", this.impactGroupId);
        jsonWriter.writeStringField("confidenceLevel",
            this.confidenceLevel == null ? null : this.confidenceLevel.toString());
        jsonWriter.writeJsonField("clientIncidentDetails", this.clientIncidentDetails);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkloadImpactProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkloadImpactProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WorkloadImpactProperties.
     */
    public static WorkloadImpactProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkloadImpactProperties deserializedWorkloadImpactProperties = new WorkloadImpactProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startDateTime".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("impactedResourceId".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.impactedResourceId = reader.getString();
                } else if ("impactCategory".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.impactCategory = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("endDateTime".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.endDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("impactUniqueId".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.impactUniqueId = reader.getString();
                } else if ("reportedTimeUtc".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.reportedTimeUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("impactDescription".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.impactDescription = reader.getString();
                } else if ("armCorrelationIds".equals(fieldName)) {
                    List<String> armCorrelationIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedWorkloadImpactProperties.armCorrelationIds = armCorrelationIds;
                } else if ("performance".equals(fieldName)) {
                    List<Performance> performance = reader.readArray(reader1 -> Performance.fromJson(reader1));
                    deserializedWorkloadImpactProperties.performance = performance;
                } else if ("connectivity".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.connectivity = Connectivity.fromJson(reader);
                } else if ("additionalProperties".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.additionalProperties
                        = WorkloadImpactPropertiesAdditionalProperties.fromJson(reader);
                } else if ("errorDetails".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.errorDetails = ErrorDetailProperties.fromJson(reader);
                } else if ("workload".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.workload = Workload.fromJson(reader);
                } else if ("impactGroupId".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.impactGroupId = reader.getString();
                } else if ("confidenceLevel".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.confidenceLevel
                        = ConfidenceLevel.fromString(reader.getString());
                } else if ("clientIncidentDetails".equals(fieldName)) {
                    deserializedWorkloadImpactProperties.clientIncidentDetails = ClientIncidentDetails.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkloadImpactProperties;
        });
    }
}
