// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.resourcemanager.impactreporting.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of WorkloadImpacts.
 */
public interface WorkloadImpacts {
    /**
     * Get a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a WorkloadImpact along with {@link Response}.
     */
    Response<WorkloadImpact> getWithResponse(String workloadImpactName, Context context);

    /**
     * Get a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a WorkloadImpact.
     */
    WorkloadImpact get(String workloadImpactName);

    /**
     * Delete a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String workloadImpactName, Context context);

    /**
     * Delete a WorkloadImpact.
     * 
     * @param workloadImpactName workloadImpact resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String workloadImpactName);

    /**
     * List WorkloadImpact resources by subscription ID.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a WorkloadImpact list operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<WorkloadImpact> list();

    /**
     * List WorkloadImpact resources by subscription ID.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of a WorkloadImpact list operation as paginated response with {@link PagedIterable}.
     */
    PagedIterable<WorkloadImpact> list(Context context);

    /**
     * Get a WorkloadImpact.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a WorkloadImpact along with {@link Response}.
     */
    WorkloadImpact getById(String id);

    /**
     * Get a WorkloadImpact.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a WorkloadImpact along with {@link Response}.
     */
    Response<WorkloadImpact> getByIdWithResponse(String id, Context context);

    /**
     * Delete a WorkloadImpact.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Delete a WorkloadImpact.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new WorkloadImpact resource.
     * 
     * @param name resource name.
     * @return the first stage of the new WorkloadImpact definition.
     */
    WorkloadImpact.DefinitionStages.Blank define(String name);
}
