/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iothub.models.ArmIdentity;
import com.azure.resourcemanager.iothub.models.IotHubProperties;
import com.azure.resourcemanager.iothub.models.IotHubSkuInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class IotHubDescriptionInner
extends Resource {
    @JsonProperty(value="etag")
    private String etag;
    @JsonProperty(value="properties")
    private IotHubProperties properties;
    @JsonProperty(value="sku", required=true)
    private IotHubSkuInfo sku;
    @JsonProperty(value="identity")
    private ArmIdentity identity;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    private static final ClientLogger LOGGER = new ClientLogger(IotHubDescriptionInner.class);

    public String etag() {
        return this.etag;
    }

    public IotHubDescriptionInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public IotHubProperties properties() {
        return this.properties;
    }

    public IotHubDescriptionInner withProperties(IotHubProperties properties) {
        this.properties = properties;
        return this;
    }

    public IotHubSkuInfo sku() {
        return this.sku;
    }

    public IotHubDescriptionInner withSku(IotHubSkuInfo sku) {
        this.sku = sku;
        return this;
    }

    public ArmIdentity identity() {
        return this.identity;
    }

    public IotHubDescriptionInner withIdentity(ArmIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public IotHubDescriptionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public IotHubDescriptionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.sku() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model IotHubDescriptionInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

