/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iothub.models.IotHubCapacity;
import com.azure.resourcemanager.iothub.models.IotHubSkuInfo;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class IotHubSkuDescriptionInner {
    @JsonProperty(value="resourceType", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceType;
    @JsonProperty(value="sku", required=true)
    private IotHubSkuInfo sku;
    @JsonProperty(value="capacity", required=true)
    private IotHubCapacity capacity;
    private static final ClientLogger LOGGER = new ClientLogger(IotHubSkuDescriptionInner.class);

    public String resourceType() {
        return this.resourceType;
    }

    public IotHubSkuInfo sku() {
        return this.sku;
    }

    public IotHubSkuDescriptionInner withSku(IotHubSkuInfo sku) {
        this.sku = sku;
        return this;
    }

    public IotHubCapacity capacity() {
        return this.capacity;
    }

    public IotHubSkuDescriptionInner withCapacity(IotHubCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model IotHubSkuDescriptionInner"));
        }
        this.sku().validate();
        if (this.capacity() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property capacity in model IotHubSkuDescriptionInner"));
        }
        this.capacity().validate();
    }
}

