/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.iothub.IotHubManager;
import com.azure.resourcemanager.iothub.fluent.models.CertificateDescriptionInner;
import com.azure.resourcemanager.iothub.implementation.Utils;
import com.azure.resourcemanager.iothub.models.CertificateDescription;
import com.azure.resourcemanager.iothub.models.CertificateProperties;

public final class CertificateDescriptionImpl
implements CertificateDescription,
CertificateDescription.Definition,
CertificateDescription.Update {
    private CertificateDescriptionInner innerObject;
    private final IotHubManager serviceManager;
    private String resourceGroupName;
    private String resourceName;
    private String certificateName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public CertificateProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CertificateDescriptionInner innerModel() {
        return this.innerObject;
    }

    private IotHubManager manager() {
        return this.serviceManager;
    }

    @Override
    public CertificateDescriptionImpl withExistingIotHub(String resourceGroupName, String resourceName) {
        this.resourceGroupName = resourceGroupName;
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public CertificateDescription create() {
        this.innerObject = (CertificateDescriptionInner)((Object)this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.certificateName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public CertificateDescription create(Context context) {
        this.innerObject = (CertificateDescriptionInner)((Object)this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.certificateName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    CertificateDescriptionImpl(String name, IotHubManager serviceManager) {
        this.innerObject = new CertificateDescriptionInner();
        this.serviceManager = serviceManager;
        this.certificateName = name;
        this.createIfMatch = null;
    }

    @Override
    public CertificateDescriptionImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public CertificateDescription apply() {
        this.innerObject = (CertificateDescriptionInner)((Object)this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.certificateName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public CertificateDescription apply(Context context) {
        this.innerObject = (CertificateDescriptionInner)((Object)this.serviceManager.serviceClient().getCertificates().createOrUpdateWithResponse(this.resourceGroupName, this.resourceName, this.certificateName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    CertificateDescriptionImpl(CertificateDescriptionInner innerObject, IotHubManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.resourceName = Utils.getValueFromIdByName(innerObject.id(), "IotHubs");
        this.certificateName = Utils.getValueFromIdByName(innerObject.id(), "certificates");
    }

    @Override
    public CertificateDescription refresh() {
        this.innerObject = (CertificateDescriptionInner)((Object)this.serviceManager.serviceClient().getCertificates().getWithResponse(this.resourceGroupName, this.resourceName, this.certificateName, Context.NONE).getValue());
        return this;
    }

    @Override
    public CertificateDescription refresh(Context context) {
        this.innerObject = (CertificateDescriptionInner)((Object)this.serviceManager.serviceClient().getCertificates().getWithResponse(this.resourceGroupName, this.resourceName, this.certificateName, context).getValue());
        return this;
    }

    @Override
    public CertificateDescriptionImpl withProperties(CertificateProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public CertificateDescriptionImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

