/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.iothub.fluent.PrivateLinkResourcesOperationsClient;
import com.azure.resourcemanager.iothub.fluent.models.GroupIdInformationInner;
import com.azure.resourcemanager.iothub.fluent.models.PrivateLinkResourcesInner;
import com.azure.resourcemanager.iothub.implementation.IotHubClientImpl;
import com.azure.resourcemanager.iothub.models.ErrorDetailsException;
import reactor.core.publisher.Mono;

public final class PrivateLinkResourcesOperationsClientImpl
implements PrivateLinkResourcesOperationsClient {
    private final PrivateLinkResourcesOperationsService service;
    private final IotHubClientImpl client;

    PrivateLinkResourcesOperationsClientImpl(IotHubClientImpl client) {
        this.service = (PrivateLinkResourcesOperationsService)RestProxy.create(PrivateLinkResourcesOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourcesInner>> listWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourcesInner>> listWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PrivateLinkResourcesInner> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((PrivateLinkResourcesInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateLinkResourcesInner> listWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateLinkResourcesInner list(String resourceGroupName, String resourceName) {
        return (PrivateLinkResourcesInner)this.listWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GroupIdInformationInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String groupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, groupId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GroupIdInformationInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String groupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, groupId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GroupIdInformationInner> getAsync(String resourceGroupName, String resourceName, String groupId) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, groupId).flatMap(res -> Mono.justOrEmpty((Object)((GroupIdInformationInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GroupIdInformationInner> getWithResponse(String resourceGroupName, String resourceName, String groupId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, groupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GroupIdInformationInner get(String resourceGroupName, String resourceName, String groupId) {
        return (GroupIdInformationInner)this.getWithResponse(resourceGroupName, resourceName, groupId, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="IotHubClientPrivateL")
    public static interface PrivateLinkResourcesOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/iotHubs/{resourceName}/privateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<PrivateLinkResourcesInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/iotHubs/{resourceName}/privateLinkResources/{groupId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<GroupIdInformationInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="groupId") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

