/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.iothub.fluent.ResourceProviderCommonsClient;
import com.azure.resourcemanager.iothub.fluent.models.UserSubscriptionQuotaListResultInner;
import com.azure.resourcemanager.iothub.implementation.IotHubClientImpl;
import com.azure.resourcemanager.iothub.models.ErrorDetailsException;
import reactor.core.publisher.Mono;

public final class ResourceProviderCommonsClientImpl
implements ResourceProviderCommonsClient {
    private final ResourceProviderCommonsService service;
    private final IotHubClientImpl client;

    ResourceProviderCommonsClientImpl(IotHubClientImpl client) {
        this.service = (ResourceProviderCommonsService)RestProxy.create(ResourceProviderCommonsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<UserSubscriptionQuotaListResultInner>> getSubscriptionQuotaWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSubscriptionQuota(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<UserSubscriptionQuotaListResultInner>> getSubscriptionQuotaWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSubscriptionQuota(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<UserSubscriptionQuotaListResultInner> getSubscriptionQuotaAsync() {
        return this.getSubscriptionQuotaWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((UserSubscriptionQuotaListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UserSubscriptionQuotaListResultInner> getSubscriptionQuotaWithResponse(Context context) {
        return (Response)this.getSubscriptionQuotaWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserSubscriptionQuotaListResultInner getSubscriptionQuota() {
        return (UserSubscriptionQuotaListResultInner)this.getSubscriptionQuotaWithResponse(Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="IotHubClientResource")
    public static interface ResourceProviderCommonsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Devices/usages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<UserSubscriptionQuotaListResultInner>> getSubscriptionQuota(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

