/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.iothub.fluent.models.IotHubDescriptionInner;
import com.azure.resourcemanager.iothub.models.ArmIdentity;
import com.azure.resourcemanager.iothub.models.ExportDevicesRequest;
import com.azure.resourcemanager.iothub.models.ImportDevicesRequest;
import com.azure.resourcemanager.iothub.models.IotHubProperties;
import com.azure.resourcemanager.iothub.models.IotHubSkuInfo;
import com.azure.resourcemanager.iothub.models.JobResponse;
import com.azure.resourcemanager.iothub.models.SharedAccessSignatureAuthorizationRule;
import java.util.Map;

public interface IotHubDescription {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public IotHubProperties properties();

    public IotHubSkuInfo sku();

    public ArmIdentity identity();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public IotHubDescriptionInner innerModel();

    public Update update();

    public IotHubDescription refresh();

    public IotHubDescription refresh(Context var1);

    public PagedIterable<SharedAccessSignatureAuthorizationRule> listKeys();

    public PagedIterable<SharedAccessSignatureAuthorizationRule> listKeys(Context var1);

    public Response<JobResponse> exportDevicesWithResponse(ExportDevicesRequest var1, Context var2);

    public JobResponse exportDevices(ExportDevicesRequest var1);

    public Response<JobResponse> importDevicesWithResponse(ImportDevicesRequest var1, Context var2);

    public JobResponse importDevices(ImportDevicesRequest var1);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public IotHubDescription apply();

        public IotHubDescription apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ArmIdentity var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(IotHubProperties var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithEtag,
        WithProperties,
        WithIdentity,
        WithIfMatch {
            public IotHubDescription create();

            public IotHubDescription create(Context var1);
        }

        public static interface WithSku {
            public WithCreate withSku(IotHubSkuInfo var1);
        }

        public static interface WithResourceGroup {
            public WithSku withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate {
    }
}

