/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.fluent.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.iothub.models.EndpointHealthStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class EndpointHealthDataInner
implements JsonSerializable<EndpointHealthDataInner> {
    private String endpointId;
    private EndpointHealthStatus healthStatus;
    private String lastKnownError;
    private DateTimeRfc1123 lastKnownErrorTime;
    private DateTimeRfc1123 lastSuccessfulSendAttemptTime;
    private DateTimeRfc1123 lastSendAttemptTime;

    public String endpointId() {
        return this.endpointId;
    }

    public EndpointHealthDataInner withEndpointId(String endpointId) {
        this.endpointId = endpointId;
        return this;
    }

    public EndpointHealthStatus healthStatus() {
        return this.healthStatus;
    }

    public EndpointHealthDataInner withHealthStatus(EndpointHealthStatus healthStatus) {
        this.healthStatus = healthStatus;
        return this;
    }

    public String lastKnownError() {
        return this.lastKnownError;
    }

    public EndpointHealthDataInner withLastKnownError(String lastKnownError) {
        this.lastKnownError = lastKnownError;
        return this;
    }

    public OffsetDateTime lastKnownErrorTime() {
        if (this.lastKnownErrorTime == null) {
            return null;
        }
        return this.lastKnownErrorTime.getDateTime();
    }

    public EndpointHealthDataInner withLastKnownErrorTime(OffsetDateTime lastKnownErrorTime) {
        this.lastKnownErrorTime = lastKnownErrorTime == null ? null : new DateTimeRfc1123(lastKnownErrorTime);
        return this;
    }

    public OffsetDateTime lastSuccessfulSendAttemptTime() {
        if (this.lastSuccessfulSendAttemptTime == null) {
            return null;
        }
        return this.lastSuccessfulSendAttemptTime.getDateTime();
    }

    public EndpointHealthDataInner withLastSuccessfulSendAttemptTime(OffsetDateTime lastSuccessfulSendAttemptTime) {
        this.lastSuccessfulSendAttemptTime = lastSuccessfulSendAttemptTime == null ? null : new DateTimeRfc1123(lastSuccessfulSendAttemptTime);
        return this;
    }

    public OffsetDateTime lastSendAttemptTime() {
        if (this.lastSendAttemptTime == null) {
            return null;
        }
        return this.lastSendAttemptTime.getDateTime();
    }

    public EndpointHealthDataInner withLastSendAttemptTime(OffsetDateTime lastSendAttemptTime) {
        this.lastSendAttemptTime = lastSendAttemptTime == null ? null : new DateTimeRfc1123(lastSendAttemptTime);
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointId", this.endpointId);
        jsonWriter.writeStringField("healthStatus", this.healthStatus == null ? null : this.healthStatus.toString());
        jsonWriter.writeStringField("lastKnownError", this.lastKnownError);
        jsonWriter.writeStringField("lastKnownErrorTime", Objects.toString(this.lastKnownErrorTime, null));
        jsonWriter.writeStringField("lastSuccessfulSendAttemptTime", Objects.toString(this.lastSuccessfulSendAttemptTime, null));
        jsonWriter.writeStringField("lastSendAttemptTime", Objects.toString(this.lastSendAttemptTime, null));
        return jsonWriter.writeEndObject();
    }

    public static EndpointHealthDataInner fromJson(JsonReader jsonReader) throws IOException {
        return (EndpointHealthDataInner)jsonReader.readObject(reader -> {
            EndpointHealthDataInner deserializedEndpointHealthDataInner = new EndpointHealthDataInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointId".equals(fieldName)) {
                    deserializedEndpointHealthDataInner.endpointId = reader.getString();
                    continue;
                }
                if ("healthStatus".equals(fieldName)) {
                    deserializedEndpointHealthDataInner.healthStatus = EndpointHealthStatus.fromString(reader.getString());
                    continue;
                }
                if ("lastKnownError".equals(fieldName)) {
                    deserializedEndpointHealthDataInner.lastKnownError = reader.getString();
                    continue;
                }
                if ("lastKnownErrorTime".equals(fieldName)) {
                    deserializedEndpointHealthDataInner.lastKnownErrorTime = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("lastSuccessfulSendAttemptTime".equals(fieldName)) {
                    deserializedEndpointHealthDataInner.lastSuccessfulSendAttemptTime = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                if ("lastSendAttemptTime".equals(fieldName)) {
                    deserializedEndpointHealthDataInner.lastSendAttemptTime = (DateTimeRfc1123)reader.getNullable(nonNullReader -> new DateTimeRfc1123(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointHealthDataInner;
        });
    }
}

